/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.uri;

import io.trino.jdbc.$internal.client.uri.ConnectionProperty;
import io.trino.jdbc.$internal.client.uri.PropertyName;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.reflect.TypeToken;
import java.io.File;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

abstract class AbstractConnectionProperty<V, T>
implements ConnectionProperty<V, T> {
    private final PropertyName propertyName;
    private final String key;
    private final Optional<T> defaultValue;
    private final Predicate<Properties> isRequired;
    private final Validator<Properties> validator;
    private final Converter<V, T> converter;
    private final String[] choices;
    protected static final Predicate<Properties> NOT_REQUIRED = properties -> false;
    protected static final Validator<Properties> ALLOWED = properties -> Optional.empty();
    protected static final Converter<String, String> STRING_CONVERTER = AbstractConnectionProperty.converter(Function.identity(), Function.identity());
    protected static final Converter<String, String> NON_EMPTY_STRING_CONVERTER = new Converter<String, String>(){

        @Override
        public String decode(String value) {
            Preconditions.checkArgument(!value.isEmpty(), "value is empty");
            return value;
        }

        @Override
        public String encode(String value) {
            return value;
        }
    };
    protected static final Converter<String, File> FILE_CONVERTER = new Converter<String, File>(){

        @Override
        public File decode(String value) {
            return Paths.get(value, new String[0]).toFile();
        }

        @Override
        public String encode(File value) {
            return value.getPath();
        }
    };
    protected static final Converter<String, Boolean> BOOLEAN_CONVERTER = new Converter<String, Boolean>(){

        @Override
        public Boolean decode(String value) {
            switch (value.toLowerCase(Locale.ENGLISH)) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new IllegalArgumentException("value must be 'true' or 'false'");
        }

        @Override
        public String encode(Boolean value) {
            return value.toString();
        }
    };

    protected AbstractConnectionProperty(PropertyName propertyName, Optional<T> defaultValue, Predicate<Properties> isRequired, Validator<Properties> validator, Converter<V, T> converter) {
        this.propertyName = Objects.requireNonNull(propertyName, "key is null");
        this.key = propertyName.toString();
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.isRequired = Objects.requireNonNull(isRequired, "isRequired is null");
        this.validator = Objects.requireNonNull(validator, "validator is null");
        this.converter = Objects.requireNonNull(converter, "converter is null");
        Class type = new TypeToken<T>(this.getClass()){}.getRawType();
        this.choices = type == Boolean.class ? new String[]{"true", "false"} : (Enum.class.isAssignableFrom(type) ? (String[])Stream.of(type.getEnumConstants()).map(Object::toString).toArray(String[]::new) : null);
    }

    protected AbstractConnectionProperty(PropertyName key, Predicate<Properties> required, Validator<Properties> allowed, Converter<V, T> converter) {
        this(key, Optional.empty(), required, allowed, converter);
    }

    @Override
    public PropertyName getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isRequired(Properties properties) {
        return this.isRequired.test(properties);
    }

    @Override
    public Optional<T> getValue(Properties properties) {
        Object value = properties.get(this.key);
        if (value == null) {
            if (this.isRequired(properties) && this.defaultValue.isEmpty()) {
                throw new RuntimeException(String.format("Connection property %s is required", this.key));
            }
            return this.defaultValue;
        }
        try {
            return Optional.of(this.decodeValue(value));
        }
        catch (RuntimeException e) {
            if (this.isEmpty(value)) {
                throw new RuntimeException(String.format("Connection property %s value is empty", this.key), e);
            }
            throw new RuntimeException(String.format("Connection property %s value is invalid: %s", this.key, value), e);
        }
    }

    @Override
    public V encodeValue(T value) {
        return this.converter.encode(value);
    }

    @Override
    public T decodeValue(V value) {
        return this.converter.decode(value);
    }

    @Override
    public String[] getChoices() {
        return this.choices;
    }

    @Override
    public Optional<RuntimeException> validate(Properties properties) {
        Optional<String> message;
        if (properties.containsKey(this.key) && (message = this.validator.validate(properties)).isPresent()) {
            return message.map(RuntimeException::new);
        }
        try {
            this.getValue(properties);
        }
        catch (RuntimeException e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    protected static <V, T> Converter<V, T> converter(final Function<V, T> decoder, final Function<T, V> encoder) {
        return new Converter<V, T>(){

            @Override
            public T decode(V value) {
                return decoder.apply(value);
            }

            @Override
            public V encode(T value) {
                return encoder.apply(value);
            }
        };
    }

    protected static <T> Validator<T> validator(Predicate<T> predicate, String errorMessage) {
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(errorMessage, "errorMessage is null");
        return value -> {
            if (predicate.test(value)) {
                return Optional.empty();
            }
            return Optional.of(errorMessage);
        };
    }

    protected static interface Validator<T> {
        public Optional<String> validate(T var1);

        default public Validator<T> and(Validator<? super T> other) {
            Objects.requireNonNull(other, "other is null");
            return t -> {
                Optional<String> result = this.validate(t);
                if (result.isPresent()) {
                    return result;
                }
                return other.validate(t);
            };
        }
    }

    static interface Converter<V, T> {
        public T decode(V var1);

        public V encode(T var1);
    }
}

