/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.okhttp3.internal.ws;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.kotlin.io.CloseableKt;
import io.trino.jdbc.$internal.kotlin.jvm.internal.Intrinsics;
import io.trino.jdbc.$internal.okhttp3.internal.ws.MessageDeflaterKt;
import io.trino.jdbc.$internal.okio.Buffer;
import io.trino.jdbc.$internal.okio.ByteString;
import io.trino.jdbc.$internal.okio.DeflaterSink;
import io.trino.jdbc.$internal.okio.Sink;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.Deflater;
import org.jetbrains.annotations.NotNull;

@.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/trino/jdbc/$internal/okhttp3/internal/ws/MessageDeflater;", "Ljava/io/Closeable;", "noContextTakeover", "", "<init>", "(Z)V", "deflatedBytes", "Lio/trino/jdbc/$internal/okio/Buffer;", "deflater", "Ljava/util/zip/Deflater;", "deflaterSink", "Lio/trino/jdbc/$internal/okio/DeflaterSink;", "deflate", "", "buffer", "close", "endsWith", "suffix", "Lio/trino/jdbc/$internal/okio/ByteString;", "okhttp"})
public final class MessageDeflater
implements Closeable {
    private final boolean noContextTakeover;
    @NotNull
    private final Buffer deflatedBytes;
    @NotNull
    private final Deflater deflater;
    @NotNull
    private final DeflaterSink deflaterSink;

    public MessageDeflater(boolean noContextTakeover) {
        this.noContextTakeover = noContextTakeover;
        this.deflatedBytes = new Buffer();
        this.deflater = new Deflater(-1, true);
        this.deflaterSink = new DeflaterSink((Sink)this.deflatedBytes, this.deflater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deflate(@NotNull Buffer buffer) throws IOException {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (!(this.deflatedBytes.size() == 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.noContextTakeover) {
            this.deflater.reset();
        }
        this.deflaterSink.write(buffer, buffer.size());
        this.deflaterSink.flush();
        if (this.endsWith(this.deflatedBytes, MessageDeflaterKt.access$getEMPTY_DEFLATE_BLOCK$p())) {
            long newSize = this.deflatedBytes.size() - (long)4;
            Closeable closeable = Buffer.readAndWriteUnsafe$default(this.deflatedBytes, null, 1, null);
            Throwable throwable = null;
            try {
                Buffer.UnsafeCursor cursor = (Buffer.UnsafeCursor)closeable;
                boolean bl = false;
                Long l = cursor.resizeBuffer(newSize);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        } else {
            this.deflatedBytes.writeByte(0);
        }
        buffer.write(this.deflatedBytes, this.deflatedBytes.size());
    }

    @Override
    public void close() throws IOException {
        this.deflaterSink.close();
    }

    private final boolean endsWith(Buffer $this$endsWith, ByteString suffix) {
        return $this$endsWith.rangeEquals($this$endsWith.size() - (long)suffix.size(), suffix);
    }
}

