/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jmx;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.jmx.JmxConnector;
import io.trino.plugin.jmx.JmxConnectorConfig;
import io.trino.plugin.jmx.JmxHandleResolver;
import io.trino.plugin.jmx.JmxHistoricalData;
import io.trino.plugin.jmx.JmxMetadata;
import io.trino.plugin.jmx.JmxPeriodicSampler;
import io.trino.plugin.jmx.JmxRecordSetProvider;
import io.trino.plugin.jmx.JmxSplitManager;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import java.util.Map;

public class JmxConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "jmx";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new JmxHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Bootstrap app = new Bootstrap(new Module[]{new MBeanServerModule(), binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(JmxConnectorConfig.class);
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
            binder.bind(JmxConnector.class).in(Scopes.SINGLETON);
            binder.bind(JmxHistoricalData.class).in(Scopes.SINGLETON);
            binder.bind(JmxMetadata.class).in(Scopes.SINGLETON);
            binder.bind(JmxSplitManager.class).in(Scopes.SINGLETON);
            binder.bind(JmxPeriodicSampler.class).in(Scopes.SINGLETON);
            binder.bind(JmxRecordSetProvider.class).in(Scopes.SINGLETON);
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(JmxConnector.class);
    }
}

