/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jmx;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.trino.plugin.jmx.JmxColumnHandle;
import io.trino.plugin.jmx.JmxErrorCode;
import io.trino.plugin.jmx.JmxHistoricalData;
import io.trino.plugin.jmx.JmxTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxMetadata
implements ConnectorMetadata {
    private static final Logger LOGGER = Logger.get(JmxMetadata.class);
    public static final String JMX_SCHEMA_NAME = "current";
    public static final String HISTORY_SCHEMA_NAME = "history";
    public static final String NODE_COLUMN_NAME = "node";
    public static final String OBJECT_NAME_NAME = "object_name";
    public static final String TIMESTAMP_COLUMN_NAME = "timestamp";
    private final MBeanServer mbeanServer;
    private final JmxHistoricalData jmxHistoricalData;

    @Inject
    public JmxMetadata(MBeanServer mbeanServer, JmxHistoricalData jmxHistoricalData) {
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
        this.jmxHistoricalData = Objects.requireNonNull(jmxHistoricalData, "jmxStatsHolder is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)JMX_SCHEMA_NAME, (Object)HISTORY_SCHEMA_NAME);
    }

    public JmxTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.getTableHandle(tableName);
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public JmxTableHandle getTableHandle(SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.getSchemaName().equals(JMX_SCHEMA_NAME)) {
            return this.getJmxTableHandle(tableName);
        }
        if (tableName.getSchemaName().equals(HISTORY_SCHEMA_NAME)) {
            return this.getJmxHistoryTableHandle(tableName);
        }
        return null;
    }

    private JmxTableHandle getJmxHistoryTableHandle(SchemaTableName tableName) {
        JmxTableHandle handle = this.getJmxTableHandle(tableName);
        if (handle == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new JmxColumnHandle(TIMESTAMP_COLUMN_NAME, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)));
        builder.addAll(handle.getColumnHandles());
        return new JmxTableHandle(handle.getTableName(), handle.getObjectNames(), (List<JmxColumnHandle>)builder.build(), false, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    private JmxTableHandle getJmxTableHandle(SchemaTableName tableName) {
        try {
            String objectNamePattern = JmxMetadata.toPattern(tableName.getTableName().toLowerCase(Locale.ENGLISH));
            List objectNames = (List)this.mbeanServer.queryNames(ObjectName.WILDCARD, null).stream().filter(name -> name.getCanonicalName().toLowerCase(Locale.ENGLISH).matches(objectNamePattern)).collect(ImmutableList.toImmutableList());
            if (objectNames.isEmpty()) {
                return null;
            }
            ArrayList<JmxColumnHandle> columns = new ArrayList<JmxColumnHandle>();
            columns.add(new JmxColumnHandle(NODE_COLUMN_NAME, (Type)VarcharType.createUnboundedVarcharType()));
            columns.add(new JmxColumnHandle(OBJECT_NAME_NAME, (Type)VarcharType.createUnboundedVarcharType()));
            for (ObjectName objectName : objectNames) {
                MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(objectName);
                this.getColumnHandles(mbeanInfo).forEach(columns::add);
            }
            columns = (List)columns.stream().distinct().sorted(Comparator.comparing(JmxColumnHandle::getColumnName)).collect(ImmutableList.toImmutableList());
            return new JmxTableHandle(tableName, (List)objectNames.stream().map(ObjectName::toString).collect(ImmutableList.toImmutableList()), columns, true, (TupleDomain<ColumnHandle>)TupleDomain.all());
        }
        catch (TrinoException | JMException e) {
            return null;
        }
    }

    public static String toPattern(String tableName) {
        try {
            if (!tableName.contains("*")) {
                return Pattern.quote(new ObjectName(tableName).getCanonicalName());
            }
            return Streams.stream((Iterable)Splitter.on((char)'*').split((CharSequence)tableName)).map(Pattern::quote).collect(Collectors.joining(".*"));
        }
        catch (MalformedObjectNameException exception) {
            LOGGER.debug((Throwable)exception, "Invalid ObjectName");
            throw new TrinoException((ErrorCodeSupplier)JmxErrorCode.JMX_INVALID_TABLE_NAME, "Not a valid ObjectName " + tableName);
        }
    }

    private Stream<JmxColumnHandle> getColumnHandles(MBeanInfo mbeanInfo) {
        return Arrays.stream(mbeanInfo.getAttributes()).filter(MBeanAttributeInfo::isReadable).map(attribute -> new JmxColumnHandle(attribute.getName(), JmxMetadata.getColumnType(attribute)));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return ((JmxTableHandle)tableHandle).getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        Set schemaNames = (Set)schemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf(this.listSchemaNames(session)));
        ImmutableList.Builder schemaTableNames = ImmutableList.builder();
        for (String schema : schemaNames) {
            if (JMX_SCHEMA_NAME.equals(schema)) {
                return this.listJmxTables();
            }
            if (!HISTORY_SCHEMA_NAME.equals(schema)) continue;
            return this.jmxHistoricalData.getTables().stream().map(tableName -> new SchemaTableName(HISTORY_SCHEMA_NAME, tableName)).collect(Collectors.toList());
        }
        return schemaTableNames.build();
    }

    private List<SchemaTableName> listJmxTables() {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(ObjectName.WILDCARD, null)) {
            tableNames.add((Object)new SchemaTableName(JMX_SCHEMA_NAME, objectName.getCanonicalName().toLowerCase(Locale.ENGLISH)));
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JmxTableHandle jmxTableHandle = (JmxTableHandle)tableHandle;
        return ImmutableMap.copyOf((Map)Maps.uniqueIndex(jmxTableHandle.getColumnHandles(), column -> column.getColumnName().toLowerCase(Locale.ENGLISH)));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((JmxColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (prefix.getSchema().isPresent() && !((String)prefix.getSchema().get()).equals(JMX_SCHEMA_NAME) && !((String)prefix.getSchema().get()).equals(HISTORY_SCHEMA_NAME)) {
            return ImmutableMap.of();
        }
        Object tableNames = prefix.getTable().isEmpty() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        return (Map)tableNames.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), tableName -> this.getTableHandle(session, (SchemaTableName)tableName).getTableMetadata().getColumns()));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        Optional domains = constraint.getSummary().getDomains();
        if (domains.isEmpty()) {
            return Optional.empty();
        }
        JmxTableHandle tableHandle = (JmxTableHandle)handle;
        LinkedHashMap nodeDomains = new LinkedHashMap();
        LinkedHashMap otherDomains = new LinkedHashMap();
        ((Map)domains.get()).forEach((column, domain) -> {
            JmxColumnHandle columnHandle = (JmxColumnHandle)column;
            if (columnHandle.getColumnName().equals(NODE_COLUMN_NAME)) {
                nodeDomains.put(column, domain);
            } else {
                otherDomains.put(column, domain);
            }
        });
        TupleDomain<ColumnHandle> oldDomain = tableHandle.getNodeFilter();
        TupleDomain newDomain = oldDomain.intersect(TupleDomain.withColumnDomains(nodeDomains));
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        JmxTableHandle newTableHandle = new JmxTableHandle(tableHandle.getTableName(), tableHandle.getObjectNames(), tableHandle.getColumnHandles(), tableHandle.isLiveData(), (TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)newTableHandle, TupleDomain.withColumnDomains(otherDomains)));
    }

    private static Type getColumnType(MBeanAttributeInfo attribute) {
        switch (attribute.getType()) {
            case "boolean": 
            case "java.lang.Boolean": {
                return BooleanType.BOOLEAN;
            }
            case "byte": 
            case "java.lang.Byte": 
            case "short": 
            case "java.lang.Short": 
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": {
                return BigintType.BIGINT;
            }
            case "java.lang.Number": 
            case "float": 
            case "java.lang.Float": 
            case "double": 
            case "java.lang.Double": {
                return DoubleType.DOUBLE;
            }
        }
        return VarcharType.createUnboundedVarcharType();
    }
}

