/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.plugin.jmx.JmxColumnHandle;
import io.trino.plugin.jmx.JmxHistoricalData;
import io.trino.plugin.jmx.JmxTableHandle;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxRecordSetProvider
implements ConnectorRecordSetProvider {
    private final MBeanServer mbeanServer;
    private final String nodeId;
    private final JmxHistoricalData jmxHistoricalData;

    @Inject
    public JmxRecordSetProvider(MBeanServer mbeanServer, NodeManager nodeManager, JmxHistoricalData jmxHistoricalData) {
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
        this.nodeId = Objects.requireNonNull(nodeManager, "nodeManager is null").getCurrentNode().getNodeIdentifier();
        this.jmxHistoricalData = Objects.requireNonNull(jmxHistoricalData, "jmxHistoryHolder is null");
    }

    public List<Object> getLiveRow(String objectName, List<? extends ColumnHandle> columns, long entryTimestamp) throws JMException {
        ImmutableMap<String, Optional<Object>> attributes = this.getAttributes(JmxRecordSetProvider.getColumnNames(columns), objectName);
        ArrayList<Object> row = new ArrayList<Object>();
        for (ColumnHandle columnHandle : columns) {
            JmxColumnHandle jmxColumn = (JmxColumnHandle)columnHandle;
            if (jmxColumn.getColumnName().equals("node")) {
                row.add(this.nodeId);
                continue;
            }
            if (jmxColumn.getColumnName().equals("object_name")) {
                row.add(objectName);
                continue;
            }
            if (jmxColumn.getColumnName().equals("timestamp")) {
                row.add(DateTimeEncoding.packDateTimeWithZone((long)entryTimestamp, (TimeZoneKey)TimeZoneKey.UTC_KEY));
                continue;
            }
            Optional optionalValue = (Optional)attributes.get((Object)jmxColumn.getColumnName());
            if (optionalValue == null || optionalValue.isEmpty()) {
                row.add(null);
                continue;
            }
            Object value = optionalValue.get();
            Class javaType = jmxColumn.getColumnType().getJavaType();
            if (javaType == Boolean.TYPE) {
                if (value instanceof Boolean) {
                    row.add(value);
                    continue;
                }
                row.add(null);
                continue;
            }
            if (javaType == Long.TYPE) {
                if (value instanceof Number) {
                    row.add(((Number)value).longValue());
                    continue;
                }
                row.add(null);
                continue;
            }
            if (javaType == Double.TYPE) {
                if (value instanceof Number) {
                    row.add(((Number)value).doubleValue());
                    continue;
                }
                row.add(null);
                continue;
            }
            if (javaType != Slice.class) continue;
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType() == Boolean.TYPE) {
                    row.add(Arrays.toString((boolean[])value));
                    continue;
                }
                if (value.getClass().getComponentType() == Byte.TYPE) {
                    row.add(Arrays.toString((byte[])value));
                    continue;
                }
                if (value.getClass().getComponentType() == Character.TYPE) {
                    row.add(Arrays.toString((char[])value));
                    continue;
                }
                if (value.getClass().getComponentType() == Double.TYPE) {
                    row.add(Arrays.toString((double[])value));
                    continue;
                }
                if (value.getClass().getComponentType() == Float.TYPE) {
                    row.add(Arrays.toString((float[])value));
                    continue;
                }
                if (value.getClass().getComponentType() == Integer.TYPE) {
                    row.add(Arrays.toString((int[])value));
                    continue;
                }
                if (value.getClass().getComponentType() == Long.TYPE) {
                    row.add(Arrays.toString((long[])value));
                    continue;
                }
                if (value.getClass().getComponentType() == Short.TYPE) {
                    row.add(Arrays.toString((short[])value));
                    continue;
                }
                row.add(Arrays.toString((Object[])value));
                continue;
            }
            row.add(value.toString());
        }
        return row;
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        Object rows;
        JmxTableHandle tableHandle = (JmxTableHandle)table;
        Objects.requireNonNull(columns, "columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        try {
            if (tableHandle.isLiveData()) {
                rows = this.getLiveRows(tableHandle, columns);
            } else {
                List<Integer> selectedColumns = this.calculateSelectedColumns(tableHandle.getColumnHandles(), JmxRecordSetProvider.getColumnNames(columns));
                rows = (List)tableHandle.getObjectNames().stream().flatMap(objectName -> this.jmxHistoricalData.getRows((String)objectName, selectedColumns).stream()).collect(ImmutableList.toImmutableList());
            }
        }
        catch (JMException e) {
            rows = ImmutableList.of();
        }
        return new InMemoryRecordSet(JmxRecordSetProvider.getColumnTypes(columns), (Iterable)rows);
    }

    private List<Integer> calculateSelectedColumns(List<JmxColumnHandle> columnHandles, Set<String> selectedColumnNames) {
        ImmutableList.Builder selectedColumns = ImmutableList.builder();
        for (int i = 0; i < columnHandles.size(); ++i) {
            JmxColumnHandle column = columnHandles.get(i);
            if (!selectedColumnNames.contains(column.getColumnName())) continue;
            selectedColumns.add((Object)i);
        }
        return selectedColumns.build();
    }

    private static Set<String> getColumnNames(List<? extends ColumnHandle> columnHandles) {
        return columnHandles.stream().map(column -> (JmxColumnHandle)column).map(JmxColumnHandle::getColumnName).collect(Collectors.toSet());
    }

    private static List<Type> getColumnTypes(List<? extends ColumnHandle> columnHandles) {
        return columnHandles.stream().map(column -> (JmxColumnHandle)column).map(JmxColumnHandle::getColumnType).collect(Collectors.toList());
    }

    private ImmutableMap<String, Optional<Object>> getAttributes(Set<String> uniqueColumnNames, String name) throws JMException {
        ObjectName objectName = new ObjectName(name);
        String[] columnNamesArray = uniqueColumnNames.toArray(new String[uniqueColumnNames.size()]);
        ImmutableMap.Builder attributes = ImmutableMap.builder();
        for (Attribute attribute : this.mbeanServer.getAttributes(objectName, columnNamesArray).asList()) {
            attributes.put((Object)attribute.getName(), Optional.ofNullable(attribute.getValue()));
        }
        return attributes.build();
    }

    private List<List<Object>> getLiveRows(JmxTableHandle tableHandle, List<? extends ColumnHandle> columns) throws JMException {
        ImmutableList.Builder rows = ImmutableList.builder();
        for (String objectName : tableHandle.getObjectNames()) {
            rows.add(this.getLiveRow(objectName, columns, 0L));
        }
        return rows.build();
    }
}

