/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jmx;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JmxSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(JmxSplit.class);
    private final List<HostAddress> addresses;

    @JsonCreator
    public JmxSplit(@JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Map<String, String> getSplitInfo() {
        return Map.of("addresses", this.addresses.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }
}

