/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import io.trino.plugin.kafka.KafkaAdminFactory;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.utils.PropertiesUtils;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DefaultKafkaAdminFactory
implements KafkaAdminFactory {
    private final Set<HostAddress> nodes;
    private final Map<String, String> configurationProperties;

    @Inject
    public DefaultKafkaAdminFactory(KafkaConfig kafkaConfig) throws Exception {
        this.nodes = kafkaConfig.getNodes();
        this.configurationProperties = PropertiesUtils.readProperties(kafkaConfig.getResourceConfigFiles());
    }

    @Override
    public Properties configure(ConnectorSession session) {
        Properties properties = new Properties();
        properties.putAll(this.configurationProperties);
        properties.setProperty("bootstrap.servers", this.nodes.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
        return properties;
    }
}

