/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class KafkaInternalFieldManager {
    private final Map<String, InternalField> fieldsByNames;
    private final Map<InternalFieldId, InternalField> fieldsByIds;

    @Inject
    public KafkaInternalFieldManager(TypeManager typeManager, KafkaConfig kafkaConfig) {
        Type varcharMapType = typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)TypeSignature.arrayType((TypeSignature)VarbinaryType.VARBINARY.getTypeSignature())));
        String prefix = kafkaConfig.getInternalFieldPrefix();
        List fields = (List)Stream.of(new InternalField(InternalFieldId.PARTITION_ID_FIELD, prefix + "partition_id", "Partition Id", (Type)BigintType.BIGINT), new InternalField(InternalFieldId.PARTITION_OFFSET_FIELD, prefix + "partition_offset", "Offset for the message within the partition", (Type)BigintType.BIGINT), new InternalField(InternalFieldId.MESSAGE_CORRUPT_FIELD, prefix + "message_corrupt", "Message data is corrupt", (Type)BooleanType.BOOLEAN), new InternalField(InternalFieldId.MESSAGE_FIELD, prefix + "message", "Message text", (Type)VarcharType.createUnboundedVarcharType()), new InternalField(InternalFieldId.HEADERS_FIELD, prefix + "headers", "Headers of the message as map", varcharMapType), new InternalField(InternalFieldId.MESSAGE_LENGTH_FIELD, prefix + "message_length", "Total number of message bytes", (Type)BigintType.BIGINT), new InternalField(InternalFieldId.KEY_CORRUPT_FIELD, prefix + "key_corrupt", "Key data is corrupt", (Type)BooleanType.BOOLEAN), new InternalField(InternalFieldId.KEY_FIELD, prefix + "key", "Key text", (Type)VarcharType.createUnboundedVarcharType()), new InternalField(InternalFieldId.KEY_LENGTH_FIELD, prefix + "key_length", "Total number of key bytes", (Type)BigintType.BIGINT), new InternalField(InternalFieldId.OFFSET_TIMESTAMP_FIELD, prefix + "timestamp", "Message timestamp", (Type)TimestampType.TIMESTAMP_MILLIS)).collect(ImmutableList.toImmutableList());
        this.fieldsByNames = (Map)fields.stream().collect(ImmutableMap.toImmutableMap(InternalField::getColumnName, Function.identity()));
        this.fieldsByIds = (Map)fields.stream().collect(ImmutableMap.toImmutableMap(InternalField::getInternalFieldId, Function.identity()));
    }

    public Collection<InternalField> getInternalFields() {
        return this.fieldsByNames.values();
    }

    public InternalField getFieldByName(String name) {
        return this.fieldsByNames.get(name);
    }

    public InternalField getFieldById(InternalFieldId id) {
        return this.fieldsByIds.get((Object)id);
    }

    public static class InternalField {
        private final InternalFieldId internalFieldId;
        private final String columnName;
        private final String comment;
        private final Type type;

        InternalField(InternalFieldId internalFieldId, String columnName, String comment, Type type) {
            this.internalFieldId = Objects.requireNonNull(internalFieldId, "internalFieldId is null");
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
            this.comment = Objects.requireNonNull(comment, "comment is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public InternalFieldId getInternalFieldId() {
            return this.internalFieldId;
        }

        public String getColumnName() {
            return this.columnName;
        }

        private Type getType() {
            return this.type;
        }

        KafkaColumnHandle getColumnHandle(boolean hidden) {
            return new KafkaColumnHandle(this.getColumnName(), this.getType(), null, null, null, false, hidden, true);
        }

        ColumnMetadata getColumnMetadata(boolean hidden) {
            return ColumnMetadata.builder().setName(this.columnName).setType(this.type).setComment(Optional.ofNullable(this.comment)).setHidden(hidden).build();
        }
    }

    public static enum InternalFieldId {
        PARTITION_ID_FIELD,
        PARTITION_OFFSET_FIELD,
        MESSAGE_CORRUPT_FIELD,
        MESSAGE_FIELD,
        MESSAGE_LENGTH_FIELD,
        HEADERS_FIELD,
        KEY_CORRUPT_FIELD,
        KEY_FIELD,
        KEY_LENGTH_FIELD,
        OFFSET_TIMESTAMP_FIELD;

    }
}

