/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.FieldValueProviders;
import io.trino.decoder.RowDecoder;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.plugin.kafka.KafkaConsumerFactory;
import io.trino.plugin.kafka.KafkaInternalFieldManager;
import io.trino.plugin.kafka.KafkaSplit;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class KafkaRecordSet
implements RecordSet {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int CONSUMER_POLL_TIMEOUT = 100;
    private final KafkaSplit split;
    private final KafkaConsumerFactory consumerFactory;
    private final ConnectorSession connectorSession;
    private final RowDecoder keyDecoder;
    private final RowDecoder messageDecoder;
    private final KafkaInternalFieldManager kafkaInternalFieldManager;
    private final List<KafkaColumnHandle> columnHandles;
    private final List<Type> columnTypes;

    KafkaRecordSet(KafkaSplit split, KafkaConsumerFactory consumerFactory, ConnectorSession connectorSession, List<KafkaColumnHandle> columnHandles, RowDecoder keyDecoder, RowDecoder messageDecoder, KafkaInternalFieldManager kafkaInternalFieldManager) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.consumerFactory = Objects.requireNonNull(consumerFactory, "consumerFactory is null");
        this.connectorSession = Objects.requireNonNull(connectorSession, "connectorSession is null");
        this.keyDecoder = Objects.requireNonNull(keyDecoder, "keyDecoder is null");
        this.messageDecoder = Objects.requireNonNull(messageDecoder, "messageDecoder is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.kafkaInternalFieldManager = Objects.requireNonNull(kafkaInternalFieldManager, "kafkaInternalFieldManager is null");
        this.columnTypes = (List)columnHandles.stream().map(KafkaColumnHandle::getType).collect(ImmutableList.toImmutableList());
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new KafkaRecordCursor();
    }

    public static FieldValueProvider headerMapValueProvider(final MapType varcharMapType, Headers headers) {
        Type keyType = (Type)varcharMapType.getTypeParameters().get(0);
        Type valueArrayType = (Type)varcharMapType.getTypeParameters().get(1);
        Type valueType = (Type)valueArrayType.getTypeParameters().get(0);
        final BlockBuilder mapBlockBuilder = varcharMapType.createBlockBuilder(null, 1);
        BlockBuilder builder = mapBlockBuilder.beginBlockEntry();
        ArrayListMultimap headerMap = ArrayListMultimap.create();
        for (Header header : headers) {
            headerMap.put((Object)header.key(), (Object)header.value());
        }
        for (String headerKey : headerMap.keySet()) {
            TypeUtils.writeNativeValue((Type)keyType, (BlockBuilder)builder, (Object)headerKey);
            BlockBuilder arrayBuilder = builder.beginBlockEntry();
            for (byte[] value : headerMap.get((Object)headerKey)) {
                TypeUtils.writeNativeValue((Type)valueType, (BlockBuilder)arrayBuilder, (Object)value);
            }
            builder.closeEntry();
        }
        mapBlockBuilder.closeEntry();
        return new FieldValueProvider(){

            public boolean isNull() {
                return false;
            }

            public Block getBlock() {
                return varcharMapType.getObject((Block)mapBlockBuilder, 0);
            }
        };
    }

    private class KafkaRecordCursor
    implements RecordCursor {
        private final TopicPartition topicPartition;
        private final KafkaConsumer<byte[], byte[]> kafkaConsumer;
        private Iterator<ConsumerRecord<byte[], byte[]>> records = Collections.emptyIterator();
        private long completedBytes;
        private final FieldValueProvider[] currentRowValues;

        private KafkaRecordCursor() {
            this.currentRowValues = new FieldValueProvider[KafkaRecordSet.this.columnHandles.size()];
            this.topicPartition = new TopicPartition(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId());
            this.kafkaConsumer = KafkaRecordSet.this.consumerFactory.create(KafkaRecordSet.this.connectorSession);
            this.kafkaConsumer.assign((Collection)ImmutableList.of((Object)this.topicPartition));
            this.kafkaConsumer.seek(this.topicPartition, KafkaRecordSet.this.split.getMessagesRange().getBegin());
        }

        public long getCompletedBytes() {
            return this.completedBytes;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return KafkaRecordSet.this.columnHandles.get(field).getType();
        }

        public boolean advanceNextPosition() {
            if (this.records.hasNext()) {
                return this.nextRow(this.records.next());
            }
            if (this.kafkaConsumer.position(this.topicPartition) >= KafkaRecordSet.this.split.getMessagesRange().getEnd()) {
                return false;
            }
            this.records = this.kafkaConsumer.poll(Duration.ofMillis(100L)).iterator();
            return this.advanceNextPosition();
        }

        private boolean nextRow(ConsumerRecord<byte[], byte[]> message) {
            Objects.requireNonNull(message, "message is null");
            if (message.offset() >= KafkaRecordSet.this.split.getMessagesRange().getEnd()) {
                return false;
            }
            this.completedBytes += (long)(Math.max(message.serializedKeySize(), 0) + Math.max(message.serializedValueSize(), 0));
            byte[] keyData = message.key() == null ? EMPTY_BYTE_ARRAY : (byte[])message.key();
            byte[] messageData = message.value() == null ? EMPTY_BYTE_ARRAY : (byte[])message.value();
            long timeStamp = message.timestamp() * 1000L;
            Optional decodedKey = KafkaRecordSet.this.keyDecoder.decodeRow(keyData);
            Optional decodedValue = message.value() == null ? Optional.empty() : KafkaRecordSet.this.messageDecoder.decodeRow(messageData);
            Map currentRowValuesMap = KafkaRecordSet.this.columnHandles.stream().filter(KafkaColumnHandle::isInternal).collect(Collectors.toMap(Function.identity(), columnHandle -> switch (this.getInternalFieldId((KafkaColumnHandle)columnHandle)) {
                default -> throw new IncompatibleClassChangeError();
                case KafkaInternalFieldManager.InternalFieldId.PARTITION_OFFSET_FIELD -> FieldValueProviders.longValueProvider((long)message.offset());
                case KafkaInternalFieldManager.InternalFieldId.MESSAGE_FIELD -> FieldValueProviders.bytesValueProvider((byte[])messageData);
                case KafkaInternalFieldManager.InternalFieldId.MESSAGE_LENGTH_FIELD -> FieldValueProviders.longValueProvider((long)messageData.length);
                case KafkaInternalFieldManager.InternalFieldId.KEY_FIELD -> FieldValueProviders.bytesValueProvider((byte[])keyData);
                case KafkaInternalFieldManager.InternalFieldId.KEY_LENGTH_FIELD -> FieldValueProviders.longValueProvider((long)keyData.length);
                case KafkaInternalFieldManager.InternalFieldId.OFFSET_TIMESTAMP_FIELD -> FieldValueProviders.longValueProvider((long)timeStamp);
                case KafkaInternalFieldManager.InternalFieldId.KEY_CORRUPT_FIELD -> FieldValueProviders.booleanValueProvider((boolean)decodedKey.isEmpty());
                case KafkaInternalFieldManager.InternalFieldId.HEADERS_FIELD -> KafkaRecordSet.headerMapValueProvider((MapType)columnHandle.getType(), message.headers());
                case KafkaInternalFieldManager.InternalFieldId.MESSAGE_CORRUPT_FIELD -> FieldValueProviders.booleanValueProvider((boolean)decodedValue.isEmpty());
                case KafkaInternalFieldManager.InternalFieldId.PARTITION_ID_FIELD -> FieldValueProviders.longValueProvider((long)message.partition());
            }));
            decodedKey.ifPresent(currentRowValuesMap::putAll);
            decodedValue.ifPresent(currentRowValuesMap::putAll);
            for (int i = 0; i < KafkaRecordSet.this.columnHandles.size(); ++i) {
                ColumnHandle columnHandle2 = KafkaRecordSet.this.columnHandles.get(i);
                this.currentRowValues[i] = currentRowValuesMap.get(columnHandle2);
            }
            return true;
        }

        private KafkaInternalFieldManager.InternalFieldId getInternalFieldId(KafkaColumnHandle columnHandle) {
            return KafkaRecordSet.this.kafkaInternalFieldManager.getFieldByName(columnHandle.getName()).getInternalFieldId();
        }

        public boolean getBoolean(int field) {
            return this.getFieldValueProvider(field, Boolean.TYPE).getBoolean();
        }

        public long getLong(int field) {
            return this.getFieldValueProvider(field, Long.TYPE).getLong();
        }

        public double getDouble(int field) {
            return this.getFieldValueProvider(field, Double.TYPE).getDouble();
        }

        public Slice getSlice(int field) {
            return this.getFieldValueProvider(field, Slice.class).getSlice();
        }

        public Object getObject(int field) {
            return this.getFieldValueProvider(field, Block.class).getBlock();
        }

        public boolean isNull(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return this.currentRowValues[field] == null || this.currentRowValues[field].isNull();
        }

        private FieldValueProvider getFieldValueProvider(int field, Class<?> expectedType) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, expectedType);
            return this.currentRowValues[field];
        }

        private void checkFieldType(int field, Class<?> expected) {
            Class actual = this.getType(field).getJavaType();
            Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
        }

        public void close() {
            this.kafkaConsumer.close();
        }
    }
}

