/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaConsumerFactory;
import io.trino.plugin.kafka.KafkaErrorCode;
import io.trino.plugin.kafka.KafkaFilterManager;
import io.trino.plugin.kafka.KafkaFilteringResult;
import io.trino.plugin.kafka.KafkaSplit;
import io.trino.plugin.kafka.KafkaTableHandle;
import io.trino.plugin.kafka.Range;
import io.trino.plugin.kafka.schema.ContentSchemaReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class KafkaSplitManager
implements ConnectorSplitManager {
    private final KafkaConsumerFactory consumerFactory;
    private final KafkaFilterManager kafkaFilterManager;
    private final ContentSchemaReader contentSchemaReader;
    private final int messagesPerSplit;

    @Inject
    public KafkaSplitManager(KafkaConsumerFactory consumerFactory, KafkaConfig kafkaConfig, KafkaFilterManager kafkaFilterManager, ContentSchemaReader contentSchemaReader) {
        this.consumerFactory = Objects.requireNonNull(consumerFactory, "consumerFactory is null");
        this.messagesPerSplit = kafkaConfig.getMessagesPerSplit();
        this.kafkaFilterManager = Objects.requireNonNull(kafkaFilterManager, "kafkaFilterManager is null");
        this.contentSchemaReader = Objects.requireNonNull(contentSchemaReader, "contentSchemaReader is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        FixedSplitSource fixedSplitSource;
        block10: {
            KafkaTableHandle kafkaTableHandle = (KafkaTableHandle)table;
            KafkaConsumer<byte[], byte[]> kafkaConsumer = this.consumerFactory.create(session);
            try {
                List<PartitionInfo> partitionInfos = kafkaConsumer.partitionsFor(kafkaTableHandle.getTopicName());
                List topicPartitions = (List)partitionInfos.stream().map(KafkaSplitManager::toTopicPartition).collect(ImmutableList.toImmutableList());
                Map<TopicPartition, Long> partitionBeginOffsets = kafkaConsumer.beginningOffsets((Collection)topicPartitions);
                Map<TopicPartition, Long> partitionEndOffsets = kafkaConsumer.endOffsets((Collection)topicPartitions);
                KafkaFilteringResult kafkaFilteringResult = this.kafkaFilterManager.getKafkaFilterResult(session, kafkaTableHandle, partitionInfos, partitionBeginOffsets, partitionEndOffsets);
                partitionInfos = kafkaFilteringResult.getPartitionInfos();
                partitionBeginOffsets = kafkaFilteringResult.getPartitionBeginOffsets();
                partitionEndOffsets = kafkaFilteringResult.getPartitionEndOffsets();
                ImmutableList.Builder splits = ImmutableList.builder();
                Optional<String> keyDataSchemaContents = this.contentSchemaReader.readKeyContentSchema(kafkaTableHandle);
                Optional<String> messageDataSchemaContents = this.contentSchemaReader.readValueContentSchema(kafkaTableHandle);
                for (PartitionInfo partitionInfo : partitionInfos) {
                    TopicPartition topicPartition = KafkaSplitManager.toTopicPartition(partitionInfo);
                    HostAddress leader = HostAddress.fromParts((String)partitionInfo.leader().host(), (int)partitionInfo.leader().port());
                    new Range(partitionBeginOffsets.get(topicPartition), partitionEndOffsets.get(topicPartition)).partition(this.messagesPerSplit).stream().map(range -> new KafkaSplit(kafkaTableHandle.getTopicName(), kafkaTableHandle.getKeyDataFormat(), kafkaTableHandle.getMessageDataFormat(), keyDataSchemaContents, messageDataSchemaContents, partitionInfo.partition(), (Range)range, leader)).forEach(arg_0 -> ((ImmutableList.Builder)splits).add(arg_0));
                }
                fixedSplitSource = new FixedSplitSource((Iterable)splits.build());
                if (kafkaConsumer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (kafkaConsumer != null) {
                        try {
                            kafkaConsumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof TrinoException) {
                        throw e;
                    }
                    throw new TrinoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, String.format("Cannot list splits for table '%s' reading topic '%s'", kafkaTableHandle.getTableName(), kafkaTableHandle.getTopicName()), (Throwable)e);
                }
            }
            kafkaConsumer.close();
        }
        return fixedSplitSource;
    }

    private static TopicPartition toTopicPartition(PartitionInfo partitionInfo) {
        return new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
    }
}

