/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DispatchingRowEncoderFactory {
    private final Map<String, RowEncoderFactory> factories;

    @Inject
    public DispatchingRowEncoderFactory(Map<String, RowEncoderFactory> factories) {
        this.factories = ImmutableMap.copyOf(Objects.requireNonNull(factories, "factories is null"));
    }

    public RowEncoder create(ConnectorSession session, String dataFormat, Optional<String> dataSchema, List<EncoderColumnHandle> columnHandles) {
        Preconditions.checkArgument((boolean)this.factories.containsKey(dataFormat), (String)"unknown data format '%s'", (Object)dataFormat);
        return this.factories.get(dataFormat).create(session, dataSchema, columnHandles);
    }
}

