/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.avro;

import com.google.common.base.Preconditions;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.encoder.avro.AvroRowEncoder;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;

public class AvroRowEncoderFactory
implements RowEncoderFactory {
    @Override
    public RowEncoder create(ConnectorSession session, Optional<String> dataSchema, List<EncoderColumnHandle> columnHandles) {
        Preconditions.checkArgument((boolean)dataSchema.isPresent(), (Object)"dataSchema for Avro format is not present");
        Schema parsedSchema = new Schema.Parser().parse(dataSchema.get());
        return new AvroRowEncoder(session, columnHandles, parsedSchema);
    }
}

