/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.encoder.json.JsonRowEncoder;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class JsonRowEncoderFactory
implements RowEncoderFactory {
    private final ObjectMapper objectMapper;

    @Inject
    public JsonRowEncoderFactory(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    @Override
    public RowEncoder create(ConnectorSession session, Optional<String> dataSchema, List<EncoderColumnHandle> columnHandles) {
        return new JsonRowEncoder(session, columnHandles, this.objectMapper);
    }
}

