/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.protobuf;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.trino.decoder.protobuf.ProtobufErrorCode;
import io.trino.plugin.kafka.encoder.AbstractRowEncoder;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ProtobufRowEncoder
extends AbstractRowEncoder {
    public static final String NAME = "protobuf";
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)RealType.REAL);
    private final Descriptors.Descriptor descriptor;
    private final DynamicMessage.Builder messageBuilder;

    public ProtobufRowEncoder(Descriptors.Descriptor descriptor, ConnectorSession session, List<EncoderColumnHandle> columnHandles) {
        super(session, columnHandles);
        for (EncoderColumnHandle columnHandle : this.columnHandles) {
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (Object)"formatHint must be null");
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (Object)"dataFormat must be null");
            Preconditions.checkArgument((boolean)this.isSupportedType(columnHandle.getType()), (String)"Unsupported column type '%s' for column '%s'", (Object)columnHandle.getType(), (Object)columnHandle.getName());
        }
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        this.messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.descriptor);
    }

    private boolean isSupportedType(Type type) {
        if (this.isSupportedPrimitive(type)) {
            return true;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return this.isSupportedType((Type)type.getTypeParameters().get(0));
        }
        if (type instanceof MapType) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            return this.isSupportedType((Type)typeParameters.get(0)) && this.isSupportedType((Type)typeParameters.get(1));
        }
        if (type instanceof RowType) {
            Preconditions.checkArgument((boolean)((RowType)type).getFields().stream().allMatch(field -> field.getName().isPresent()), (Object)"expecting name for field in rows");
            for (Type fieldType : type.getTypeParameters()) {
                if (this.isSupportedType(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isSupportedPrimitive(Type type) {
        return type instanceof TimestampType && ((TimestampType)type).isShort() || type instanceof VarcharType || type instanceof VarbinaryType || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    @Override
    protected void appendNullValue() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Protobuf doesn't support serializing null values");
    }

    @Override
    protected void appendLong(long value) {
        this.append(value);
    }

    @Override
    protected void appendInt(int value) {
        this.append(value);
    }

    @Override
    protected void appendShort(short value) {
        this.append(value);
    }

    @Override
    protected void appendDouble(double value) {
        this.append(value);
    }

    @Override
    protected void appendFloat(float value) {
        this.append(Float.valueOf(value));
    }

    @Override
    protected void appendByte(byte value) {
        this.append(value);
    }

    @Override
    protected void appendBoolean(boolean value) {
        this.append(value);
    }

    @Override
    protected void appendString(String value) {
        this.append(value);
    }

    @Override
    protected void appendByteBuffer(ByteBuffer value) {
        this.append(value);
    }

    @Override
    protected void appendArray(List<Object> value) {
        this.append(value);
    }

    @Override
    protected void appendSqlTimestamp(SqlTimestamp value) {
        this.append(value);
    }

    @Override
    protected void appendMap(Map<Object, Object> value) {
        this.append(value);
    }

    @Override
    protected void appendRow(List<Object> value) {
        this.append(value);
    }

    @Override
    public byte[] toByteArray() {
        this.resetColumnIndex();
        try {
            byte[] byArray = this.messageBuilder.build().toByteArray();
            return byArray;
        }
        finally {
            this.messageBuilder.clear();
        }
    }

    private void append(Object value) {
        this.setField(this.descriptor, this.messageBuilder, ((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getType(), ((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getMapping(), value);
    }

    private DynamicMessage setField(Descriptors.Descriptor descriptor, DynamicMessage.Builder messageBuilder, Type type, String columnMapping, Object value) {
        List columnPath = Splitter.on((String)"/").omitEmptyStrings().limit(2).splitToList((CharSequence)columnMapping);
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName((String)columnPath.get(0));
        Preconditions.checkState((fieldDescriptor != null ? 1 : 0) != 0, (Object)String.format("Unknown Field %s", columnPath.get(0)));
        if (columnPath.size() == 2) {
            Preconditions.checkState((fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? 1 : 0) != 0, (String)"Expected MESSAGE type, but got: %s", (Object)fieldDescriptor.getJavaType());
            value = this.setField(fieldDescriptor.getMessageType(), DynamicMessage.newBuilder((Message)((DynamicMessage)messageBuilder.getField(fieldDescriptor))), type, (String)columnPath.get(1), value);
        } else {
            value = this.encodeObject(fieldDescriptor, type, value);
        }
        this.setField(fieldDescriptor, messageBuilder, value);
        return messageBuilder.build();
    }

    private Object encodeObject(Descriptors.FieldDescriptor fieldDescriptor, Type type, Object value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Protobuf doesn't support serializing null values");
        }
        if (type instanceof VarbinaryType) {
            if (value instanceof SqlVarbinary) {
                SqlVarbinary sqlVarbinary = (SqlVarbinary)value;
                return ByteString.copyFrom((byte[])sqlVarbinary.getBytes());
            }
            if (value instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)value;
                return ByteString.copyFrom((ByteBuffer)byteBuffer, (int)byteBuffer.limit());
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("cannot decode object of '%s' as '%s'", value.getClass(), type));
        }
        if (type instanceof TimestampType) {
            Preconditions.checkArgument((boolean)(value instanceof SqlTimestamp), (Object)"value should be an instance of SqlTimestamp");
            return this.encodeTimestamp((SqlTimestamp)value);
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((boolean)(value instanceof List), (Object)"value should be an instance of List<Object>");
            return this.encodeArray(fieldDescriptor, type, (List)value);
        }
        if (type instanceof MapType) {
            Preconditions.checkArgument((boolean)(value instanceof Map), (Object)"value should be an instance of Map<Object, Object>");
            return this.encodeMap(fieldDescriptor, type, (Map)value);
        }
        if (type instanceof RowType) {
            Preconditions.checkArgument((boolean)(value instanceof List), (Object)"value should be an instance of List<Object>");
            return this.encodeRow(fieldDescriptor, type, (List)value);
        }
        return value;
    }

    private Timestamp encodeTimestamp(SqlTimestamp timestamp) {
        int nanos = Math.floorMod(timestamp.getEpochMicros(), 1000000) * 1000;
        try {
            return Timestamps.checkValid((Timestamp)Timestamp.newBuilder().setSeconds(Math.floorDiv(timestamp.getEpochMicros(), 1000000)).setNanos(nanos).build());
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)ProtobufErrorCode.INVALID_TIMESTAMP, e.getMessage());
        }
    }

    private List<Object> encodeArray(Descriptors.FieldDescriptor fieldDescriptor, Type type, List<Object> value) {
        return (List)value.stream().map(entry -> this.encodeObject(fieldDescriptor, (Type)type.getTypeParameters().get(0), entry)).collect(ImmutableList.toImmutableList());
    }

    private List<DynamicMessage> encodeMap(Descriptors.FieldDescriptor fieldDescriptor, Type type, Map<Object, Object> value) {
        Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
        ImmutableList.Builder dynamicMessageListBuilder = ImmutableList.builder();
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
            this.setField(descriptor.findFieldByNumber(1), builder, this.encodeObject(descriptor.findFieldByNumber(1), (Type)type.getTypeParameters().get(0), entry.getKey()));
            this.setField(descriptor.findFieldByNumber(2), builder, this.encodeObject(descriptor.findFieldByNumber(2), (Type)type.getTypeParameters().get(1), entry.getValue()));
            dynamicMessageListBuilder.add((Object)builder.build());
        }
        return dynamicMessageListBuilder.build();
    }

    private DynamicMessage encodeRow(Descriptors.FieldDescriptor fieldDescriptor, Type type, List<Object> value) {
        Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        RowType rowType = (RowType)type;
        int index = 0;
        for (RowType.Field field : rowType.getFields()) {
            Preconditions.checkArgument((boolean)field.getName().isPresent(), (Object)"FieldName is absent");
            this.setField(descriptor.findFieldByName((String)field.getName().get()), builder, this.encodeObject(descriptor.findFieldByName((String)field.getName().get()), field.getType(), value.get(index)));
            ++index;
        }
        return builder.build();
    }

    private void setField(Descriptors.FieldDescriptor fieldDescriptor, DynamicMessage.Builder builder, Object value) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            value = fieldDescriptor.getEnumType().findValueByName((String)value);
        }
        builder.setField(fieldDescriptor, value);
    }
}

