/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.protobuf;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.trino.plugin.kafka.KafkaTopicFieldDescription;
import io.trino.plugin.kafka.KafkaTopicFieldGroup;
import io.trino.plugin.kafka.schema.confluent.SchemaParser;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public class ProtobufSchemaParser
implements SchemaParser {
    private static final String TIMESTAMP_TYPE_NAME = "google.protobuf.Timestamp";
    private final TypeManager typeManager;

    @Inject
    public ProtobufSchemaParser(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public KafkaTopicFieldGroup parse(ConnectorSession session, String subject, ParsedSchema parsedSchema) {
        ProtobufSchema protobufSchema = (ProtobufSchema)parsedSchema;
        return new KafkaTopicFieldGroup("protobuf", Optional.empty(), Optional.of(subject), (List)Streams.concat((Stream[])new Stream[]{this.getFields(protobufSchema.toDescriptor()), this.getOneofs(protobufSchema)}).collect(ImmutableList.toImmutableList()));
    }

    private Stream<KafkaTopicFieldDescription> getFields(Descriptors.Descriptor descriptor) {
        Set oneofFieldNames = (Set)descriptor.getOneofs().stream().map(Descriptors.OneofDescriptor::getFields).flatMap(Collection::stream).map(Descriptors.FieldDescriptor::getName).collect(ImmutableSet.toImmutableSet());
        return descriptor.getFields().stream().filter(field -> !oneofFieldNames.contains(field.getName())).map(field -> new KafkaTopicFieldDescription(field.getName(), this.getType((Descriptors.FieldDescriptor)field, (List<FieldAndType>)ImmutableList.of()), field.getName(), null, null, null, false));
    }

    private Stream<KafkaTopicFieldDescription> getOneofs(ProtobufSchema protobufSchema) {
        return protobufSchema.toDescriptor().getOneofs().stream().map(oneofDescriptor -> new KafkaTopicFieldDescription(oneofDescriptor.getName(), this.typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0])), oneofDescriptor.getName(), null, null, null, false));
    }

    private Type getType(Descriptors.FieldDescriptor fieldDescriptor, List<FieldAndType> processedMessages) {
        BooleanType baseType;
        switch (fieldDescriptor.getJavaType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BOOLEAN: {
                BooleanType booleanType = BooleanType.BOOLEAN;
                break;
            }
            case INT: {
                BooleanType booleanType = IntegerType.INTEGER;
                break;
            }
            case LONG: {
                BooleanType booleanType = BigintType.BIGINT;
                break;
            }
            case FLOAT: {
                BooleanType booleanType = RealType.REAL;
                break;
            }
            case DOUBLE: {
                BooleanType booleanType = DoubleType.DOUBLE;
                break;
            }
            case BYTE_STRING: {
                BooleanType booleanType = VarbinaryType.VARBINARY;
                break;
            }
            case STRING: 
            case ENUM: {
                BooleanType booleanType = VarcharType.createUnboundedVarcharType();
                break;
            }
            case MESSAGE: {
                BooleanType booleanType = baseType = this.getTypeForMessage(fieldDescriptor, processedMessages);
            }
        }
        if (fieldDescriptor.isRepeated() && !fieldDescriptor.isMapField()) {
            return new ArrayType((Type)baseType);
        }
        return baseType;
    }

    private Type getTypeForMessage(Descriptors.FieldDescriptor fieldDescriptor, List<FieldAndType> processedMessages) {
        Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
        if (descriptor.getFullName().equals(TIMESTAMP_TYPE_NAME)) {
            return TimestampType.createTimestampType((int)6);
        }
        Set processedMessagesFullTypeNames = (Set)processedMessages.stream().map(FieldAndType::fullTypeName).collect(ImmutableSet.toImmutableSet());
        if (processedMessagesFullTypeNames.contains(descriptor.getFullName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Protobuf schema containing fields with self-reference are not supported because they cannot be mapped to a Trino type: %s".formatted(Streams.concat((Stream[])new Stream[]{processedMessages.stream(), Stream.of(new FieldAndType(fieldDescriptor))}).map(FieldAndType::toString).collect(Collectors.joining(" > "))));
        }
        ImmutableList newProcessedMessages = ImmutableList.builderWithExpectedSize((int)(processedMessages.size() + 1)).addAll(processedMessages).add((Object)new FieldAndType(fieldDescriptor)).build();
        if (fieldDescriptor.isMapField()) {
            return new MapType(this.getType(descriptor.findFieldByNumber(1), (List<FieldAndType>)newProcessedMessages), this.getType(descriptor.findFieldByNumber(2), (List<FieldAndType>)newProcessedMessages), this.typeManager.getTypeOperators());
        }
        return RowType.from((List)((List)descriptor.getFields().stream().map(arg_0 -> this.lambda$getTypeForMessage$3((List)newProcessedMessages, arg_0)).collect(ImmutableList.toImmutableList())));
    }

    private /* synthetic */ RowType.Field lambda$getTypeForMessage$3(List newProcessedMessages, Descriptors.FieldDescriptor field) {
        return RowType.field((String)field.getName(), (Type)this.getType(field, newProcessedMessages));
    }

    public record FieldAndType(String fullFieldName, String fullTypeName) {
        public FieldAndType(Descriptors.FieldDescriptor fieldDescriptor) {
            this(fieldDescriptor.getFullName(), fieldDescriptor.getMessageType().getFullName());
        }

        @Override
        public String toString() {
            return this.fullFieldName + ": " + this.fullTypeName;
        }
    }
}

