/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.trino.plugin.kafka.security.KafkaEndpointIdentificationAlgorithm;
import io.trino.plugin.kafka.security.KafkaKeystoreTruststoreType;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaSslConfig {
    private String keystoreLocation;
    private String keystorePassword;
    private KafkaKeystoreTruststoreType keystoreType = KafkaKeystoreTruststoreType.JKS;
    private String truststoreLocation;
    private String truststorePassword;
    private KafkaKeystoreTruststoreType truststoreType = KafkaKeystoreTruststoreType.JKS;
    private String keyPassword;
    private KafkaEndpointIdentificationAlgorithm endpointIdentificationAlgorithm = KafkaEndpointIdentificationAlgorithm.HTTPS;

    public Optional<@FileExists String> getKeystoreLocation() {
        return Optional.ofNullable(this.keystoreLocation);
    }

    @Config(value="kafka.ssl.keystore.location")
    @ConfigDescription(value="The location of the key store file. This can be used for two-way authentication for client")
    public KafkaSslConfig setKeystoreLocation(String keystoreLocation) {
        this.keystoreLocation = keystoreLocation;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="kafka.ssl.keystore.password")
    @ConfigDescription(value="The store password for the key store file")
    @ConfigSecuritySensitive
    public KafkaSslConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public Optional<KafkaKeystoreTruststoreType> getKeystoreType() {
        return Optional.ofNullable(this.keystoreType);
    }

    @Config(value="kafka.ssl.keystore.type")
    @ConfigDescription(value="The file format of the key store file")
    public KafkaSslConfig setKeystoreType(KafkaKeystoreTruststoreType keystoreType) {
        this.keystoreType = keystoreType;
        return this;
    }

    public Optional<@FileExists String> getTruststoreLocation() {
        return Optional.ofNullable(this.truststoreLocation);
    }

    @Config(value="kafka.ssl.truststore.location")
    @ConfigDescription(value="The location of the trust store file")
    public KafkaSslConfig setTruststoreLocation(String truststoreLocation) {
        this.truststoreLocation = truststoreLocation;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="kafka.ssl.truststore.password")
    @ConfigDescription(value="The password for the trust store file")
    @ConfigSecuritySensitive
    public KafkaSslConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    public Optional<KafkaKeystoreTruststoreType> getTruststoreType() {
        return Optional.ofNullable(this.truststoreType);
    }

    @Config(value="kafka.ssl.truststore.type")
    @ConfigDescription(value="The file format of the trust store file")
    public KafkaSslConfig setTruststoreType(KafkaKeystoreTruststoreType truststoreType) {
        this.truststoreType = truststoreType;
        return this;
    }

    public Optional<String> getKeyPassword() {
        return Optional.ofNullable(this.keyPassword);
    }

    @Config(value="kafka.ssl.key.password")
    @ConfigDescription(value="The password of the private key in the key store file")
    @ConfigSecuritySensitive
    public KafkaSslConfig setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public Optional<KafkaEndpointIdentificationAlgorithm> getEndpointIdentificationAlgorithm() {
        return Optional.ofNullable(this.endpointIdentificationAlgorithm);
    }

    @Config(value="kafka.ssl.endpoint-identification-algorithm")
    @ConfigDescription(value="The endpoint identification algorithm to validate server hostname using server certificate")
    public KafkaSslConfig setEndpointIdentificationAlgorithm(KafkaEndpointIdentificationAlgorithm endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
        return this;
    }

    public Map<String, Object> getKafkaClientProperties() {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        this.getKeystoreLocation().ifPresent(v -> properties.put((Object)"ssl.keystore.location", v));
        this.getKeystorePassword().ifPresent(v -> properties.put((Object)"ssl.keystore.password", v));
        this.getKeystoreType().ifPresent(v -> properties.put((Object)"ssl.keystore.type", (Object)v.name()));
        this.getTruststoreLocation().ifPresent(v -> properties.put((Object)"ssl.truststore.location", v));
        this.getTruststorePassword().ifPresent(v -> properties.put((Object)"ssl.truststore.password", v));
        this.getTruststoreType().ifPresent(v -> properties.put((Object)"ssl.truststore.type", (Object)v.name()));
        this.getKeyPassword().ifPresent(v -> properties.put((Object)"ssl.key.password", v));
        this.getEndpointIdentificationAlgorithm().ifPresent(v -> properties.put((Object)"ssl.endpoint.identification.algorithm", (Object)v.getValue()));
        properties.put((Object)"security.protocol", (Object)SecurityProtocol.SSL.name());
        return properties.buildOrThrow();
    }

    @PostConstruct
    public void validate() {
        if (this.getKeystoreLocation().isPresent() && this.getKeystorePassword().isEmpty()) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("kafka.ssl.keystore.password must set when kafka.ssl.keystore.location is given")));
        }
        if (this.getTruststoreLocation().isPresent() && this.getTruststorePassword().isEmpty()) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("kafka.ssl.truststore.password must set when kafka.ssl.truststore.location is given")));
        }
    }
}

