/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.kafka.KafkaClientsModule;
import io.trino.plugin.kafka.KafkaConnector;
import io.trino.plugin.kafka.KafkaConnectorModule;
import io.trino.plugin.kafka.security.KafkaSecurityModule;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KafkaConnectorFactory
implements ConnectorFactory {
    private final List<Module> extensions;

    public KafkaConnectorFactory(List<Module> extensions) {
        this.extensions = ImmutableList.copyOf(extensions);
    }

    public String getName() {
        return "kafka";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.builder().add((Object)new CatalogNameModule(catalogName)).add((Object)new JsonModule()).add((Object)new TypeDeserializerModule(context.getTypeManager())).add((Object)new KafkaConnectorModule(context.getTypeManager())).add((Object)new KafkaClientsModule()).add((Object)new KafkaSecurityModule()).add(binder -> {
            binder.bind(ClassLoader.class).toInstance((Object)KafkaConnectorFactory.class.getClassLoader());
            binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
        }).addAll(this.extensions).build());
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(KafkaConnector.class);
    }
}

