/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record KafkaTableHandle(String schemaName, String tableName, String topicName, String keyDataFormat, String messageDataFormat, Optional<String> keyDataSchemaLocation, Optional<String> messageDataSchemaLocation, Optional<String> keySubject, Optional<String> messageSubject, List<KafkaColumnHandle> columns, TupleDomain<ColumnHandle> constraint) implements ConnectorTableHandle,
ConnectorInsertTableHandle
{
    public KafkaTableHandle {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(topicName, "topicName is null");
        Objects.requireNonNull(keyDataFormat, "keyDataFormat is null");
        Objects.requireNonNull(messageDataFormat, "messageDataFormat is null");
        Objects.requireNonNull(keyDataSchemaLocation, "keyDataSchemaLocation is null");
        Objects.requireNonNull(messageDataSchemaLocation, "messageDataSchemaLocation is null");
        Objects.requireNonNull(keySubject, "keySubject is null");
        Objects.requireNonNull(messageSubject, "messageSubject is null");
        columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        Objects.requireNonNull(constraint, "constraint is null");
    }

    public SchemaTableName schemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }
}

