/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.plugin.kafka.KafkaProducerFactory;
import io.trino.plugin.kafka.security.ForKafkaSsl;
import io.trino.plugin.kafka.security.KafkaSslConfig;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class SslKafkaProducerFactory
implements KafkaProducerFactory {
    private final Map<String, Object> map;
    private final KafkaProducerFactory delegate;

    @Inject
    public SslKafkaProducerFactory(@ForKafkaSsl KafkaProducerFactory delegate, KafkaSslConfig sslConfig) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.map = ImmutableMap.copyOf(sslConfig.getKafkaClientProperties());
    }

    @Override
    public Properties configure(ConnectorSession session) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.delegate.configure(session));
        properties.putAll(this.map);
        return properties;
    }
}

