/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json.format;

import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RFC2822DateTimeFormatter
implements JsonDateTimeFormatter {
    private static final DateTimeFormatter RFC_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.ENGLISH).withChronology((Chronology)ISOChronology.getInstanceUTC());

    public static boolean isSupportedType(Type type) {
        return type.equals((Object)TimestampType.TIMESTAMP_MILLIS) || type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    }

    @Override
    public String formatTimestamp(SqlTimestamp value) {
        return RFC_FORMATTER.withZoneUTC().print((ReadableInstant)new DateTime(value.getMillis(), DateTimeZone.UTC));
    }

    @Override
    public String formatTimestampWithZone(SqlTimestampWithTimeZone value) {
        DateTimeZone dateTimeZone = DateTimeZone.forID((String)value.getTimeZoneKey().getId());
        return RFC_FORMATTER.withZone(dateTimeZone).print((ReadableInstant)new DateTime(value.getEpochMillis(), dateTimeZone));
    }
}

