/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.AssertTrue;
import java.util.Optional;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaSecurityConfig {
    private SecurityProtocol securityProtocol;

    public Optional<SecurityProtocol> getSecurityProtocol() {
        return Optional.ofNullable(this.securityProtocol);
    }

    @Config(value="kafka.security-protocol")
    @ConfigDescription(value="Kafka communication security protocol")
    public KafkaSecurityConfig setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    @AssertTrue(message="Only PLAINTEXT and SSL security protocols are supported. See 'kafka.config.resources' if other security protocols are needed")
    public @AssertTrue(message="Only PLAINTEXT and SSL security protocols are supported. See 'kafka.config.resources' if other security protocols are needed") boolean isValidSecurityProtocol() {
        return this.securityProtocol == null || this.securityProtocol.equals((Object)SecurityProtocol.PLAINTEXT) || this.securityProtocol.equals((Object)SecurityProtocol.SSL);
    }
}

