/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.encoder.RowEncoderSpec;
import io.trino.plugin.kafka.encoder.json.JsonRowEncoder;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;

public class JsonRowEncoderFactory
implements RowEncoderFactory {
    private final ObjectMapper objectMapper;

    @Inject
    public JsonRowEncoderFactory(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    @Override
    public RowEncoder create(ConnectorSession session, RowEncoderSpec rowEncoderSpec) {
        return new JsonRowEncoder(session, rowEncoderSpec.columnHandles(), this.objectMapper);
    }
}

