/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.decoder.avro.AvroReaderSupplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;

public class ConfluentAvroReaderSupplier<T>
implements AvroReaderSupplier<T> {
    private final Schema targetSchema;
    private final SchemaRegistryClient schemaRegistryClient;
    private final NonEvictableLoadingCache<Integer, GenericDatumReader<T>> avroRecordReaderCache;

    private ConfluentAvroReaderSupplier(Schema targetSchema, SchemaRegistryClient schemaRegistryClient) {
        this.targetSchema = Objects.requireNonNull(targetSchema, "targetSchema is null");
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient is null");
        this.avroRecordReaderCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L), (CacheLoader)CacheLoader.from(this::lookupReader));
    }

    private GenericDatumReader<T> lookupReader(int id) {
        try {
            Schema sourceSchema = Objects.requireNonNull(this.schemaRegistryClient.getById(id), "Schema is null");
            return new GenericDatumReader(sourceSchema, this.targetSchema);
        }
        catch (RestClientException | IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Looking up schemaId '%s'from confluent schema registry failed", id), e);
        }
    }

    public DatumReader<T> get(ByteBuffer buffer) {
        Preconditions.checkState((buffer.get() == 0 ? 1 : 0) != 0, (Object)"Unexpected format");
        int schemaId = buffer.getInt();
        return (DatumReader)this.avroRecordReaderCache.getUnchecked((Object)schemaId);
    }

    public static class Factory
    implements AvroReaderSupplier.Factory {
        private final SchemaRegistryClient schemaRegistryClient;

        @Inject
        public Factory(SchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient is null");
        }

        public <T> AvroReaderSupplier<T> create(Schema schema) {
            return new ConfluentAvroReaderSupplier(schema, this.schemaRegistryClient);
        }
    }
}

