/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.kinesis.KinesisMetadata;
import io.trino.plugin.kinesis.KinesisRecordSetProvider;
import io.trino.plugin.kinesis.KinesisSessionProperties;
import io.trino.plugin.kinesis.KinesisSplitManager;
import io.trino.plugin.kinesis.KinesisTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;

public class KinesisConnector
implements Connector {
    private final KinesisMetadata metadata;
    private final KinesisSplitManager splitManager;
    private final KinesisRecordSetProvider recordSetProvider;
    private final List<PropertyMetadata<?>> propertyList;

    @Inject
    public KinesisConnector(KinesisMetadata metadata, KinesisSplitManager splitManager, KinesisRecordSetProvider recordSetProvider, KinesisSessionProperties properties) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.propertyList = ImmutableList.copyOf(properties.getSessionProperties());
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return KinesisTransactionHandle.INSTANCE;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.propertyList;
    }
}

