/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.kinesis.KinesisClientManager;
import io.trino.plugin.kinesis.KinesisClientProvider;
import io.trino.plugin.kinesis.KinesisConnector;
import io.trino.plugin.kinesis.KinesisModule;
import io.trino.plugin.kinesis.KinesisStreamDescription;
import io.trino.plugin.kinesis.KinesisTableDescriptionSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class KinesisConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "kinesis";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Versions.checkSpiVersion((ConnectorContext)context, (ConnectorFactory)this);
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new KinesisModule(), binder -> {
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(KinesisClientProvider.class).to(KinesisClientManager.class).in(Scopes.SINGLETON);
                binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, KinesisStreamDescription>>>(){}).to(KinesisTableDescriptionSupplier.class).in(Scopes.SINGLETON);
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(KinesisConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

