/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.decoder.DispatchingRowDecoderFactory;
import io.trino.decoder.RowDecoder;
import io.trino.plugin.kinesis.KinesisClientProvider;
import io.trino.plugin.kinesis.KinesisColumnHandle;
import io.trino.plugin.kinesis.KinesisConfig;
import io.trino.plugin.kinesis.KinesisRecordSet;
import io.trino.plugin.kinesis.KinesisSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class KinesisRecordSetProvider
implements ConnectorRecordSetProvider {
    private final KinesisClientProvider clientManager;
    private final long dynamoReadCapacity;
    private final long dynamoWriteCapacity;
    private final boolean isLogBatches;
    private final int fetchAttempts;
    private final Duration sleepTime;
    private final DispatchingRowDecoderFactory decoderFactory;

    @Inject
    public KinesisRecordSetProvider(DispatchingRowDecoderFactory decoderFactory, KinesisClientProvider clientManager, KinesisConfig kinesisConfig) {
        this.decoderFactory = Objects.requireNonNull(decoderFactory, "decoderFactory is null");
        this.clientManager = Objects.requireNonNull(clientManager, "clientManager is null");
        Objects.requireNonNull(kinesisConfig, "kinesisConfig is null");
        this.dynamoReadCapacity = kinesisConfig.getDynamoReadCapacity();
        this.dynamoWriteCapacity = kinesisConfig.getDynamoWriteCapacity();
        this.isLogBatches = kinesisConfig.isLogBatches();
        this.fetchAttempts = kinesisConfig.getFetchAttempts();
        this.sleepTime = kinesisConfig.getSleepTime();
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        KinesisSplit kinesisSplit = (KinesisSplit)split;
        List kinesisColumns = (List)columns.stream().map(x -> (KinesisColumnHandle)x).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder handleBuilder = ImmutableList.builder();
        RowDecoder messageDecoder = this.decoderFactory.create(kinesisSplit.getMessageDataFormat(), new HashMap(), (Set)kinesisColumns.stream().filter(column -> !column.isInternal()).collect(ImmutableSet.toImmutableSet()));
        for (ColumnHandle columnHandle : columns) {
            KinesisColumnHandle columnHandle2 = (KinesisColumnHandle)columnHandle;
            handleBuilder.add((Object)columnHandle2);
        }
        return new KinesisRecordSet(kinesisSplit, session, this.clientManager, (List<KinesisColumnHandle>)handleBuilder.build(), messageDecoder, this.dynamoReadCapacity, this.dynamoWriteCapacity, this.isLogBatches, this.fetchAttempts, this.sleepTime);
    }
}

