/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.kinesis.KinesisColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public enum KinesisInternalFieldDescription {
    SHARD_ID_FIELD("_shard_id", (Type)VarcharType.VARCHAR, "Shard Id"),
    SEGMENT_START_FIELD("_segment_start", (Type)VarcharType.VARCHAR, "Segment start sequence id"),
    SEGMENT_END_FIELD("_shard_sequence_id", (Type)VarcharType.VARCHAR, "Segment end sequence id"),
    SHARD_SEQUENCE_ID_FIELD("_shard_sequence_id_field", (Type)BigintType.BIGINT, "Segment start offset"),
    SEGMENT_COUNT_FIELD("_segment_count", (Type)BigintType.BIGINT, "Running message count per segment"),
    MESSAGE_VALID_FIELD("_message_valid", (Type)BooleanType.BOOLEAN, "Message data is valid"),
    MESSAGE_FIELD("_message", (Type)VarcharType.VARCHAR, "Message text"),
    MESSAGE_TIMESTAMP("_message_timestamp", (Type)TimestampType.TIMESTAMP_MILLIS, "Approximate message arrival timestamp"),
    MESSAGE_LENGTH_FIELD("_message_length", (Type)BigintType.BIGINT, "Total number of message bytes"),
    PARTITION_KEY_FIELD("_partition_key", (Type)VarcharType.VARCHAR, "Key text");

    private static final Map<String, KinesisInternalFieldDescription> BY_COLUMN_NAME;
    private final String columnName;
    private final Type type;
    private final String comment;

    public static KinesisInternalFieldDescription forColumnName(String columnName) {
        KinesisInternalFieldDescription description = BY_COLUMN_NAME.get(columnName);
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (String)"Unknown internal column name %s", (Object)columnName);
        return description;
    }

    private KinesisInternalFieldDescription(String columnName, Type type, String comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)columnName) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.columnName = columnName;
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getType() {
        return this.type;
    }

    KinesisColumnHandle getColumnHandle(int index, boolean hidden) {
        return new KinesisColumnHandle(index, this.getColumnName(), this.getType(), null, null, null, false, hidden);
    }

    ColumnMetadata getColumnMetadata(boolean hidden) {
        return ColumnMetadata.builder().setName(this.columnName).setType(this.type).setComment(Optional.ofNullable(this.comment)).setHidden(hidden).build();
    }

    static {
        BY_COLUMN_NAME = (Map)Arrays.stream(KinesisInternalFieldDescription.values()).collect(ImmutableMap.toImmutableMap(KinesisInternalFieldDescription::getColumnName, Function.identity()));
    }
}

