/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLeaseManager;
import com.amazonaws.services.kinesis.leases.impl.Lease;
import io.airlift.log.Logger;
import io.trino.plugin.kinesis.KinesisSplit;

public class KinesisShardCheckpointer {
    private static final Logger log = Logger.get(KinesisShardCheckpointer.class);
    private final KinesisClientLeaseManager leaseManager;
    private final KinesisSplit kinesisSplit;
    private final String logicalProcessName;
    private final int currentIterationNumber;
    private final KinesisClientLease kinesisClientLease;

    public KinesisShardCheckpointer(AmazonDynamoDB dynamoDBClient, String dynamoDBTable, KinesisSplit kinesisSplit, String logicalProcessName, int currentIterationNumber, long dynamoReadCapacity, long dynamoWriteCapacity) {
        this(new KinesisClientLeaseManager(dynamoDBTable, dynamoDBClient), kinesisSplit, logicalProcessName, currentIterationNumber, dynamoReadCapacity, dynamoWriteCapacity);
    }

    public KinesisShardCheckpointer(KinesisClientLeaseManager leaseManager, KinesisSplit kinesisSplit, String logicalProcessName, int currentIterationNumber, long dynamoReadCapacity, long dynamoWriteCapacity) {
        this.leaseManager = leaseManager;
        this.kinesisSplit = kinesisSplit;
        this.logicalProcessName = logicalProcessName;
        this.currentIterationNumber = currentIterationNumber;
        try {
            this.leaseManager.createLeaseTableIfNotExists(Long.valueOf(dynamoReadCapacity), Long.valueOf(dynamoWriteCapacity));
            KinesisClientLease oldLease = (KinesisClientLease)this.leaseManager.getLease(this.createCheckpointKey(currentIterationNumber));
            if (oldLease != null) {
                this.kinesisClientLease = oldLease;
            } else {
                this.kinesisClientLease = new KinesisClientLease();
                this.kinesisClientLease.setLeaseKey(this.createCheckpointKey(currentIterationNumber));
            }
        }
        catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
            throw new RuntimeException(e);
        }
    }

    private String createCheckpointKey(int iterationNo) {
        return "%s_%s_%s_%d".formatted(this.logicalProcessName, this.kinesisSplit.getStreamName(), this.kinesisSplit.getShardId(), iterationNo);
    }

    public void checkpoint(String lastReadSequenceNumber) {
        log.info("Trying to checkpoint at %s", new Object[]{lastReadSequenceNumber});
        try {
            ExtendedSequenceNumber esn = new ExtendedSequenceNumber(lastReadSequenceNumber);
            this.kinesisClientLease.setCheckpoint(esn);
            this.leaseManager.createLeaseIfNotExists((Lease)this.kinesisClientLease);
            if (!this.leaseManager.updateLease((Lease)this.kinesisClientLease)) {
                log.warn("Checkpointing unsuccessful");
            }
        }
        catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLastReadSeqNumber() {
        String lastReadSeqNumber = null;
        if (this.currentIterationNumber > 0) {
            KinesisClientLease oldLease;
            try {
                oldLease = (KinesisClientLease)this.leaseManager.getLease(this.createCheckpointKey(this.currentIterationNumber - 1));
            }
            catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
                throw new RuntimeException(e);
            }
            if (oldLease != null) {
                lastReadSeqNumber = oldLease.getCheckpoint().toString();
            }
        }
        if (lastReadSeqNumber == null) {
            log.info("Previous checkpoint not found. Starting from beginning of shard");
        } else {
            log.info("Resuming from %s", new Object[]{lastReadSeqNumber});
        }
        return lastReadSeqNumber;
    }
}

