/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.plugin.kinesis.KinesisCompressionCodec;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Objects;

public class KinesisSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(KinesisSplit.class);
    private final String streamName;
    private final String messageDataFormat;
    private final KinesisCompressionCodec compressionCodec;
    private final String shardId;
    private final String start;
    private final String end;

    @JsonCreator
    public KinesisSplit(@JsonProperty(value="streamName") String streamName, @JsonProperty(value="messageDataFormat") String messageDataFormat, @JsonProperty(value="compressionCodec") KinesisCompressionCodec compressionCodec, @JsonProperty(value="shardId") String shardId, @JsonProperty(value="start") String start, @JsonProperty(value="end") String end) {
        this.streamName = Objects.requireNonNull(streamName, "streamName is null");
        this.messageDataFormat = Objects.requireNonNull(messageDataFormat, "messageDataFormat is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.shardId = shardId;
        this.start = start;
        this.end = end;
    }

    @JsonProperty
    public String getStart() {
        return this.start;
    }

    @JsonProperty
    public String getEnd() {
        return this.end;
    }

    @JsonProperty
    public String getStreamName() {
        return this.streamName;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    @JsonProperty
    public KinesisCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @JsonProperty
    public String getShardId() {
        return this.shardId;
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.streamName) + SizeOf.estimatedSizeOf((String)this.messageDataFormat) + SizeOf.estimatedSizeOf((String)this.shardId) + SizeOf.estimatedSizeOf((String)this.start) + SizeOf.estimatedSizeOf((String)this.end);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("streamName", (Object)this.streamName).add("messageDataFormat", (Object)this.messageDataFormat).add("compressionCodec", (Object)this.compressionCodec).add("shardId", (Object)this.shardId).add("start", (Object)this.start).add("end", (Object)this.end).toString();
    }
}

