/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ldapgroup;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.NotNull;

public class LdapGroupProviderConfig {
    private String ldapAdminUser;
    private String ldapAdminPassword;
    private String ldapUserBaseDN;
    private String ldapUserSearchFilter = "(uid={0})";
    private String ldapGroupsNameAttribute = "cn";
    private boolean ldapUseGroupFilter;

    @NotNull
    public String getLdapAdminUser() {
        return this.ldapAdminUser;
    }

    @Config(value="ldap.admin-user")
    @ConfigDescription(value="Bind distinguished name for admin user. Example: CN=User Name,OU=CITY_OU,OU=STATE_OU,DC=domain,DC=domain_root")
    public LdapGroupProviderConfig setLdapAdminUser(String ldapAdminUser) {
        this.ldapAdminUser = ldapAdminUser;
        return this;
    }

    @NotNull
    public String getLdapAdminPassword() {
        return this.ldapAdminPassword;
    }

    @ConfigSecuritySensitive
    @Config(value="ldap.admin-password")
    @ConfigDescription(value="Bind password used for admin user. Example: password1234")
    public LdapGroupProviderConfig setLdapAdminPassword(String ldapAdminPassword) {
        this.ldapAdminPassword = ldapAdminPassword;
        return this;
    }

    @NotNull
    public String getLdapUserBaseDN() {
        return this.ldapUserBaseDN;
    }

    @Config(value="ldap.user-base-dn")
    @ConfigDescription(value="Base distinguished name for users. Example: dc=example,dc=com")
    public LdapGroupProviderConfig setLdapUserBaseDN(String ldapUserBaseDN) {
        this.ldapUserBaseDN = ldapUserBaseDN;
        return this;
    }

    @NotNull
    public String getLdapUserSearchFilter() {
        return this.ldapUserSearchFilter;
    }

    @Config(value="ldap.user-search-filter")
    @ConfigDescription(value="Search filter for user documents, templated with the Trino username. Example: (cn={0})")
    public LdapGroupProviderConfig setLdapUserSearchFilter(String ldapUserSearchFilter) {
        this.ldapUserSearchFilter = ldapUserSearchFilter;
        return this;
    }

    @NotNull
    public String getLdapGroupsNameAttribute() {
        return this.ldapGroupsNameAttribute;
    }

    @Config(value="ldap.group-name-attribute")
    @ConfigDescription(value="Attribute from group documents used as the name. Example: cn")
    public LdapGroupProviderConfig setLdapGroupsNameAttribute(String ldapGroupsNameAttribute) {
        this.ldapGroupsNameAttribute = ldapGroupsNameAttribute;
        return this;
    }

    public boolean getLdapUseGroupFilter() {
        return this.ldapUseGroupFilter;
    }

    @Config(value="ldap.use-group-filter")
    @ConfigDescription(value="Enable group filtering")
    public LdapGroupProviderConfig setLdapUseGroupFilter(boolean ldapUseGroupFilter) {
        this.ldapUseGroupFilter = ldapUseGroupFilter;
        return this;
    }
}

