/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ldapgroup;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.base.ldap.LdapClientModule;
import io.trino.plugin.ldapgroup.LdapGroupProviderModule;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.GroupProviderFactory;
import java.util.Map;
import java.util.Objects;

public class LdapGroupProviderFactory
implements GroupProviderFactory {
    public String getName() {
        return "ldap";
    }

    public GroupProvider create(Map<String, String> requiredConfig) {
        Objects.requireNonNull(requiredConfig, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new LdapClientModule(), new LdapGroupProviderModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (GroupProvider)injector.getInstance(GroupProvider.class);
    }
}

