/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ldapgroup;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.base.ldap.LdapClient;
import io.trino.plugin.base.ldap.LdapQuery;
import io.trino.plugin.ldapgroup.LdapFilteringGroupProviderConfig;
import io.trino.plugin.ldapgroup.LdapGroupProviderConfig;
import io.trino.spi.security.GroupProvider;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;

public class LdapFilteringGroupProvider
implements GroupProvider {
    private static final Logger log = Logger.get(LdapFilteringGroupProvider.class);
    private final LdapClient ldapClient;
    private final String ldapAdminUser;
    private final String ldapAdminPassword;
    private final String userBaseDN;
    private final String userSearchFilter;
    private final String groupBaseDN;
    private final String groupsNameAttribute;
    private final String combinedGroupSearchFilter;

    @Inject
    public LdapFilteringGroupProvider(LdapClient ldapClient, LdapGroupProviderConfig config, LdapFilteringGroupProviderConfig filteringConfig) {
        this.ldapClient = Objects.requireNonNull(ldapClient, "ldapClient is null");
        this.ldapAdminUser = config.getLdapAdminUser();
        this.ldapAdminPassword = config.getLdapAdminPassword();
        this.userBaseDN = config.getLdapUserBaseDN();
        this.userSearchFilter = config.getLdapUserSearchFilter();
        this.groupBaseDN = filteringConfig.getLdapGroupBaseDN();
        this.groupsNameAttribute = config.getLdapGroupsNameAttribute();
        String groupsSearchMemberAttribute = filteringConfig.getLdapGroupsSearchMemberAttribute();
        this.combinedGroupSearchFilter = filteringConfig.getLdapGroupsSearchFilter().map(filter -> String.format("(&(%s)(%s={0}))", filter, groupsSearchMemberAttribute)).orElse(String.format("(%s={0})", groupsSearchMemberAttribute));
    }

    public Set<String> getGroups(String user) {
        Optional userDistinguishedName;
        try {
            userDistinguishedName = (Optional)this.ldapClient.executeLdapQuery(this.ldapAdminUser, this.ldapAdminPassword, new LdapQuery.LdapQueryBuilder().withSearchBase(this.userBaseDN).withSearchFilter(this.userSearchFilter).withFilterArguments(new Object[]{user}).build(), search -> {
                if (!search.hasMore()) {
                    log.warn("LDAP search for user [%s] using filter pattern [%s] found no matches", new Object[]{user, this.userSearchFilter});
                    return Optional.empty();
                }
                SearchResult result = (SearchResult)search.next();
                return Optional.of(result.getNameInNamespace());
            });
        }
        catch (NamingException e) {
            log.error((Throwable)e, "LDAP search for user [%s] failed", new Object[]{user});
            return ImmutableSet.of();
        }
        return (Set)userDistinguishedName.map(ldapUser -> {
            try {
                return (ImmutableSet)this.ldapClient.executeLdapQuery(this.ldapAdminUser, this.ldapAdminPassword, new LdapQuery.LdapQueryBuilder().withSearchBase(this.groupBaseDN).withAttributes(new String[]{this.groupsNameAttribute}).withSearchFilter(this.combinedGroupSearchFilter).withFilterArguments(new Object[]{ldapUser}).build(), search -> {
                    if (!search.hasMore()) {
                        log.debug("No groups found using search [pattern=%s, arguments={%s}]", new Object[]{this.combinedGroupSearchFilter, ldapUser});
                    }
                    ImmutableSet.Builder groupsBuilder = ImmutableSet.builder();
                    while (search.hasMore()) {
                        SearchResult groupResult = (SearchResult)search.next();
                        Attribute groupName = groupResult.getAttributes().get(this.groupsNameAttribute);
                        if (groupName == null) {
                            log.warn("The group object [%s] does not have group name attribute [%s]. Falling back on object full name.", new Object[]{groupResult, this.groupsNameAttribute});
                            groupsBuilder.add((Object)groupResult.getNameInNamespace());
                            continue;
                        }
                        groupsBuilder.add((Object)groupName.get().toString());
                    }
                    return groupsBuilder.build();
                });
            }
            catch (NamingException e) {
                log.error((Throwable)e, "LDAP search for user [%s] groups failed", new Object[]{user});
                return ImmutableSet.of();
            }
        }).orElse(ImmutableSet.of());
    }
}

