/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ldapgroup;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;

public class LdapFilteringGroupProviderConfig {
    private String ldapGroupBaseDN;
    private String ldapGroupsSearchFilter;
    private String ldapGroupsSearchMemberAttribute = "member";

    @NotNull
    public String getLdapGroupBaseDN() {
        return this.ldapGroupBaseDN;
    }

    @Config(value="ldap.group-base-dn")
    @ConfigDescription(value="Base distinguished name for groups. Example: dc=example,dc=com")
    public LdapFilteringGroupProviderConfig setLdapGroupBaseDN(String ldapGroupBaseDN) {
        this.ldapGroupBaseDN = ldapGroupBaseDN;
        return this;
    }

    @NotNull
    public Optional<String> getLdapGroupsSearchFilter() {
        return Optional.ofNullable(this.ldapGroupsSearchFilter);
    }

    @Config(value="ldap.group-search-filter")
    @ConfigDescription(value="Search filter for group documents. Example: (cn=trino_*)")
    public LdapFilteringGroupProviderConfig setLdapGroupsSearchFilter(String ldapGroupsSearchFilter) {
        this.ldapGroupsSearchFilter = ldapGroupsSearchFilter;
        return this;
    }

    @NotNull
    public String getLdapGroupsSearchMemberAttribute() {
        return this.ldapGroupsSearchMemberAttribute;
    }

    @Config(value="ldap.group-search-member-attribute")
    @ConfigDescription(value="Attribute from group documents used for filtering by member. Example: cn")
    public LdapFilteringGroupProviderConfig setLdapGroupsSearchMemberAttribute(String ldapGroupsSearchMemberAttribute) {
        this.ldapGroupsSearchMemberAttribute = ldapGroupsSearchMemberAttribute;
        return this;
    }
}

