/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ldapgroup;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.base.ldap.LdapClient;
import io.trino.plugin.base.ldap.LdapQuery;
import io.trino.plugin.ldapgroup.LdapFilteringGroupProvider;
import io.trino.plugin.ldapgroup.LdapGroupProviderConfig;
import io.trino.plugin.ldapgroup.LdapSingleQueryGroupProviderConfig;
import io.trino.spi.security.GroupProvider;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class LdapSingleQueryGroupProvider
implements GroupProvider {
    private static final Logger log = Logger.get(LdapFilteringGroupProvider.class);
    private final LdapClient ldapClient;
    private final String ldapAdminUser;
    private final String ldapAdminPassword;
    private final String userBaseDN;
    private final String groupsNameAttribute;
    private final String userSearchFilter;
    private final String userMemberOfAttribute;

    @Inject
    public LdapSingleQueryGroupProvider(LdapClient ldapClient, LdapGroupProviderConfig config, LdapSingleQueryGroupProviderConfig singleQueryGroupProviderConfig) {
        this.ldapClient = Objects.requireNonNull(ldapClient, "ldapClient is null");
        this.ldapAdminUser = config.getLdapAdminUser();
        this.ldapAdminPassword = config.getLdapAdminPassword();
        this.userBaseDN = config.getLdapUserBaseDN();
        this.groupsNameAttribute = config.getLdapGroupsNameAttribute();
        this.userSearchFilter = config.getLdapUserSearchFilter();
        this.userMemberOfAttribute = singleQueryGroupProviderConfig.getLdapUserMemberOfAttribute();
    }

    public Set<String> getGroups(String user) {
        try {
            return (Set)this.ldapClient.executeLdapQuery(this.ldapAdminUser, this.ldapAdminPassword, new LdapQuery.LdapQueryBuilder().withSearchBase(this.userBaseDN).withAttributes(new String[]{this.userMemberOfAttribute}).withSearchFilter(this.userSearchFilter).withFilterArguments(new Object[]{user}).build(), search -> {
                if (!search.hasMore()) {
                    log.debug("LDAP search for user [%s] using filter pattern [%s] found no matches", new Object[]{user, this.userSearchFilter});
                    return ImmutableSet.of();
                }
                SearchResult result = (SearchResult)search.next();
                Attribute attribute = result.getAttributes().get(this.userMemberOfAttribute);
                if (attribute == null) {
                    log.warn("User [%s] does not have the memberOf attribute [%s]", new Object[]{user, this.userMemberOfAttribute});
                    return ImmutableSet.of();
                }
                return (ImmutableSet)Streams.stream(attribute.getAll().asIterator()).map(Object::toString).map(this::getGroupRelativeDomainName).flatMap(Optional::stream).collect(ImmutableSet.toImmutableSet());
            });
        }
        catch (NamingException e) {
            log.error((Throwable)e, "LDAP search for user [%s] failed", new Object[]{user});
            return ImmutableSet.of();
        }
    }

    private Optional<String> getGroupRelativeDomainName(String groupDistinguishedName) {
        LdapName groupLdapName;
        try {
            groupLdapName = new LdapName(groupDistinguishedName);
        }
        catch (NamingException namingException) {
            log.warn((Throwable)namingException, "Group has malformed DN [%s]. Ignoring group.", new Object[]{groupDistinguishedName});
            return Optional.empty();
        }
        List<Rdn> groupRelativeDomainNames = groupLdapName.getRdns();
        if (groupRelativeDomainNames.isEmpty()) {
            log.warn("Group with DN [%s] has no Relative Domain Names. Ignoring group.", new Object[]{groupDistinguishedName});
            return Optional.empty();
        }
        Rdn lastRelativeDomainName = groupRelativeDomainNames.getLast();
        if (!lastRelativeDomainName.getType().equalsIgnoreCase(this.groupsNameAttribute)) {
            log.warn("Last Relative Domain Name of group with DN [%s] has the wrong type, expecting [%s], actual [%s]. Using DN.", new Object[]{groupDistinguishedName, this.groupsNameAttribute, lastRelativeDomainName.getType()});
            return Optional.of(groupDistinguishedName);
        }
        return Optional.of(lastRelativeDomainName.getValue().toString());
    }
}

