/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class LokiConfig {
    private URI uri;
    private Duration queryTimeout = new Duration(10.0, TimeUnit.SECONDS);

    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @Config(value="loki.uri")
    @ConfigDescription(value="Loki API endpoint base")
    public LokiConfig setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getQueryTimeout() {
        return this.queryTimeout;
    }

    @Config(value="loki.query-timeout")
    @ConfigDescription(value="How much time a query to Loki has before timing out")
    public LokiConfig setQueryTimeout(Duration queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }
}

