/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class LokiConnector
implements Connector {
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorRecordSetProvider recordSetProvider;
    private final Set<ConnectorTableFunction> connectorTableFunctions;

    @Inject
    public LokiConnector(ConnectorMetadata metadata, ConnectorSplitManager splitManager, ConnectorRecordSetProvider recordSetProvider, Set<ConnectorTableFunction> connectorTableFunctions) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.connectorTableFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(connectorTableFunctions, "connectorTableFunctions is null"));
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return LokiTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.connectorTableFunctions;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public static enum LokiTransactionHandle implements ConnectorTransactionHandle
    {
        INSTANCE;

    }
}

