/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import io.github.jeschkies.loki.client.model.Matrix;
import io.github.jeschkies.loki.client.model.MetricPoint;
import io.trino.plugin.loki.LokiQueryResultIterator;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;

public class LokiMatrixValuePairsIterator
implements LokiQueryResultIterator {
    private final Iterator<Point> metrics;
    private Point current;

    public LokiMatrixValuePairsIterator(Matrix matrix) {
        this.metrics = matrix.getMetrics().stream().flatMap(metric -> metric.values().stream().map(value -> new Point((MetricPoint)value, metric.labels()))).iterator();
    }

    @Override
    public boolean advanceNextPosition() {
        if (!this.metrics.hasNext()) {
            return false;
        }
        this.current = this.metrics.next();
        return true;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.current.labels;
    }

    @Override
    public long getTimestamp() {
        return LokiMatrixValuePairsIterator.toTimeWithTimeZone(this.current.timeAndValue.getTs());
    }

    @Override
    public Object getValue() {
        return this.current.timeAndValue.getValue();
    }

    private static long toTimeWithTimeZone(Long seconds) {
        return DateTimeEncoding.packDateTimeWithZone((long)Instant.ofEpochSecond(seconds).toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    record Point(MetricPoint timeAndValue, Map<String, String> labels) {
    }
}

