/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.github.jeschkies.loki.client.LokiClient;
import io.github.jeschkies.loki.client.LokiClientException;
import io.github.jeschkies.loki.client.model.Data;
import io.trino.plugin.loki.LokiColumnHandle;
import io.trino.plugin.loki.LokiErrorCode;
import io.trino.plugin.loki.LokiTableHandle;
import io.trino.plugin.loki.QueryRangeTableFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LokiMetadata
implements ConnectorMetadata {
    private static final String TABLE_NAME = "default";
    private final Type labelsMapType;
    private final LokiClient lokiClient;

    @Inject
    public LokiMetadata(LokiClient lokiClient, TypeManager typeManager) {
        this.lokiClient = Objects.requireNonNull(lokiClient, "lokiClient is null");
        this.labelsMapType = typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof QueryRangeTableFunction.QueryHandle)) {
            return Optional.empty();
        }
        QueryRangeTableFunction.QueryHandle queryHandle = (QueryRangeTableFunction.QueryHandle)handle;
        LokiTableHandle tableHandle = queryHandle.tableHandle();
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, tableHandle.columnHandles()));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        LokiTableHandle lokiTableHandle = (LokiTableHandle)table;
        List columns = (List)lokiTableHandle.columnHandles().stream().map(LokiColumnHandle.class::cast).map(LokiColumnHandle::columnMetadata).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(new SchemaTableName("system", TABLE_NAME), columns);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        throw new TrinoException((ErrorCodeSupplier)LokiErrorCode.LOKI_TABLE_ERROR, "Loki connector does not support querying tables directly. Use the TABLE function instead.");
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        LokiColumnHandle lokiColumnHandler = (LokiColumnHandle)columnHandle;
        return lokiColumnHandler.columnMetadata();
    }

    public List<ColumnHandle> getColumnHandles(String query) {
        ImmutableList.Builder columnsBuilder = ImmutableList.builderWithExpectedSize((int)3);
        columnsBuilder.add((Object)new LokiColumnHandle("labels", this.labelsMapType, 0));
        columnsBuilder.add((Object)new LokiColumnHandle("timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, 1));
        try {
            DoubleType valueType = this.lokiClient.getExpectedResultType(query) == Data.ResultType.Matrix ? DoubleType.DOUBLE : VarcharType.VARCHAR;
            columnsBuilder.add((Object)new LokiColumnHandle("value", (Type)valueType, 2));
        }
        catch (LokiClientException e) {
            throw new TrinoException((ErrorCodeSupplier)LokiErrorCode.LOKI_CLIENT_ERROR, (Throwable)e);
        }
        return columnsBuilder.build();
    }
}

