/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.github.jeschkies.loki.client.LokiClient;
import io.github.jeschkies.loki.client.LokiClientConfig;
import io.trino.plugin.loki.LokiConfig;
import io.trino.plugin.loki.LokiConnector;
import io.trino.plugin.loki.LokiMetadata;
import io.trino.plugin.loki.LokiRecordSetProvider;
import io.trino.plugin.loki.LokiSplitManager;
import io.trino.plugin.loki.LokiTableFunctionProvider;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.function.table.ConnectorTableFunction;

public class LokiModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(LokiConnector.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).to(LokiMetadata.class).in(Scopes.SINGLETON);
        binder.bind(LokiMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(LokiSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).to(LokiRecordSetProvider.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(LokiTableFunctionProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(LokiConfig.class);
    }

    @Provides
    @Singleton
    public static LokiClient getLokiClient(LokiConfig config) {
        return new LokiClient(new LokiClientConfig(config.getUri(), config.getQueryTimeout().toJavaTime()));
    }
}

