/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.loki.LokiColumnHandle;
import io.trino.plugin.loki.LokiQueryResultIterator;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LokiRecordCursor
implements RecordCursor {
    private final List<LokiColumnHandle> columnHandles;
    private final LokiQueryResultIterator resultIterator;
    private boolean advanced;

    public LokiRecordCursor(List<LokiColumnHandle> columnHandles, LokiQueryResultIterator queryResult) {
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        Objects.requireNonNull(queryResult, "queryResult is null");
        this.resultIterator = queryResult;
        this.columnHandles = (List)columnHandles.stream().sorted(Comparator.comparing(LokiColumnHandle::ordinalPosition)).collect(ImmutableList.toImmutableList());
    }

    public boolean advanceNextPosition() {
        this.advanced = true;
        return this.resultIterator.advanceNextPosition();
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).type();
    }

    public boolean getBoolean(int field) {
        throw new UnsupportedOperationException("Loki connector does not support boolean fields");
    }

    public long getLong(int field) {
        this.checkFieldType(field, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
        return (Long)Objects.requireNonNull(this.getFieldValue(field));
    }

    public double getDouble(int field) {
        this.checkFieldType(field, (Type)DoubleType.DOUBLE);
        return (Double)Objects.requireNonNull(this.getFieldValue(field));
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, (Type)VarcharType.createUnboundedVarcharType());
        return Slices.utf8Slice((String)((String)Objects.requireNonNull(this.getFieldValue(field))));
    }

    public Object getObject(int field) {
        return this.getFieldValue(field);
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.getFieldValue(field) == null;
    }

    private Object getFieldValue(int field) {
        Preconditions.checkState((boolean)this.advanced, (Object)"Cursor has not been advanced yet");
        if (field < 0 || field >= this.columnHandles.size()) {
            throw new IllegalArgumentException("Invalid field index: " + field);
        }
        LokiColumnHandle column = this.columnHandles.get(field);
        return switch (column.name()) {
            case "labels" -> LokiRecordCursor.getSqlMapFromLabels((MapType)column.type(), this.resultIterator.getLabels());
            case "timestamp" -> this.resultIterator.getTimestamp();
            case "value" -> this.resultIterator.getValue();
            default -> throw new IllegalArgumentException("Unknown column: " + column.name());
        };
    }

    public void close() {
    }

    private void checkFieldType(int field, Type expected) {
        Type actual = this.getType(field);
        Preconditions.checkArgument((boolean)actual.equals((Object)expected), (String)"Expected field %s to be type %s but is %s", (Object)field, (Object)expected, (Object)actual);
    }

    static SqlMap getSqlMapFromLabels(MapType mapType, Map<String, String> labels) {
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        return MapValueBuilder.buildMapValue((MapType)mapType, (int)labels.size(), (keyBuilder, valueBuilder) -> labels.forEach((key, value) -> {
            TypeUtils.writeNativeValue((Type)keyType, (BlockBuilder)keyBuilder, (Object)key);
            TypeUtils.writeNativeValue((Type)valueType, (BlockBuilder)valueBuilder, (Object)value);
        }));
    }
}

