/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import com.google.common.collect.ImmutableList;
import io.github.jeschkies.loki.client.LokiClient;
import io.github.jeschkies.loki.client.LokiClientException;
import io.github.jeschkies.loki.client.model.Matrix;
import io.github.jeschkies.loki.client.model.QueryResult;
import io.github.jeschkies.loki.client.model.Streams;
import io.trino.plugin.loki.LokiColumnHandle;
import io.trino.plugin.loki.LokiErrorCode;
import io.trino.plugin.loki.LokiMatrixValuePairsIterator;
import io.trino.plugin.loki.LokiRecordCursor;
import io.trino.plugin.loki.LokiSplit;
import io.trino.plugin.loki.LokiStreamEntriesIterator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public class LokiRecordSet
implements RecordSet {
    private final List<LokiColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final QueryResult result;

    public LokiRecordSet(LokiClient lokiClient, LokiSplit split, List<LokiColumnHandle> columnHandles) {
        Objects.requireNonNull(lokiClient, "lokiClient is null");
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.columnHandles = ImmutableList.copyOf(columnHandles);
        this.columnTypes = (List)columnHandles.stream().map(LokiColumnHandle::type).collect(ImmutableList.toImmutableList());
        try {
            this.result = lokiClient.rangeQuery(split.query(), split.start(), split.end(), split.step(), 0);
        }
        catch (LokiClientException e) {
            throw new TrinoException((ErrorCodeSupplier)LokiErrorCode.LOKI_CLIENT_ERROR, (Throwable)e);
        }
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        QueryResult.Result result = this.result.getData().getResult();
        Objects.requireNonNull(result);
        QueryResult.Result result2 = result;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Streams.class, Matrix.class}, (QueryResult.Result)result2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Streams streams = (Streams)result2;
                yield new LokiRecordCursor(this.columnHandles, new LokiStreamEntriesIterator(streams));
            }
            case 1 -> {
                Matrix matrix = (Matrix)result2;
                yield new LokiRecordCursor(this.columnHandles, new LokiMatrixValuePairsIterator(matrix));
            }
        };
    }
}

