/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.github.jeschkies.loki.client.LokiClient;
import io.trino.plugin.loki.LokiColumnHandle;
import io.trino.plugin.loki.LokiRecordSet;
import io.trino.plugin.loki.LokiSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;

public class LokiRecordSetProvider
implements ConnectorRecordSetProvider {
    private final LokiClient lokiClient;

    @Inject
    public LokiRecordSetProvider(LokiClient lokiClient) {
        this.lokiClient = Objects.requireNonNull(lokiClient, "lokiClient is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        LokiSplit lokiSplit = (LokiSplit)split;
        List handles = (List)columns.stream().map(LokiColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return new LokiRecordSet(this.lokiClient, lokiSplit, handles);
    }
}

