/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import io.github.jeschkies.loki.client.model.LogEntry;
import io.github.jeschkies.loki.client.model.Streams;
import io.trino.plugin.loki.LokiQueryResultIterator;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import java.util.Iterator;
import java.util.Map;

public class LokiStreamEntriesIterator
implements LokiQueryResultIterator {
    private final Iterator<LabelledEntry> entries;
    private LabelledEntry current;

    public LokiStreamEntriesIterator(Streams streamsResult) {
        this.entries = streamsResult.getStreams().stream().flatMap(stream -> stream.values().stream().map(value -> new LabelledEntry((LogEntry)value, stream.labels()))).iterator();
    }

    @Override
    public boolean advanceNextPosition() {
        if (!this.entries.hasNext()) {
            return false;
        }
        this.current = this.entries.next();
        return true;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.current.labels;
    }

    @Override
    public long getTimestamp() {
        return LokiStreamEntriesIterator.toTimeWithTimeZone(this.current.entry.getTs());
    }

    @Override
    public Object getValue() {
        return this.current.entry.getLine();
    }

    private static long toTimeWithTimeZone(Long nanos) {
        return DateTimeEncoding.packDateTimeWithZone((long)(nanos / 1000000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    record LabelledEntry(LogEntry entry, Map<String, String> labels) {
    }
}

