/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.loki;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.loki.LokiColumnHandle;
import io.trino.plugin.loki.LokiMetadata;
import io.trino.plugin.loki.LokiTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.reflect.UndeclaredThrowableException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class QueryRangeTableFunction
extends AbstractConnectorTableFunction {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "query_range";
    private final LokiMetadata metadata;

    public QueryRangeTableFunction(LokiMetadata metadata) {
        super(SCHEMA_NAME, NAME, List.of(ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build(), ScalarArgumentSpecification.builder().name("START").type((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS).build(), ScalarArgumentSpecification.builder().name("END").type((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS).build(), ScalarArgumentSpecification.builder().name("STEP").type((Type)IntegerType.INTEGER).defaultValue((Object)0L).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
        List<ColumnHandle> columnHandles;
        ScalarArgument argument = (ScalarArgument)arguments.get("QUERY");
        String query = ((Slice)argument.getValue()).toStringUtf8();
        LongTimestampWithTimeZone startArgument = (LongTimestampWithTimeZone)((ScalarArgument)arguments.get("START")).getValue();
        LongTimestampWithTimeZone endArgument = (LongTimestampWithTimeZone)((ScalarArgument)arguments.get("END")).getValue();
        Long step = (Long)((ScalarArgument)arguments.get("STEP")).getValue();
        if (step == null || step < 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "step must be positive");
        }
        if (Strings.isNullOrEmpty((String)query)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, query);
        }
        Objects.requireNonNull(startArgument, "startArgument is null");
        Objects.requireNonNull(endArgument, "endArgument is null");
        try {
            columnHandles = this.metadata.getColumnHandles(query);
        }
        catch (UndeclaredThrowableException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot get column definition", Throwables.getRootCause((Throwable)e));
        }
        Preconditions.checkArgument((!columnHandles.isEmpty() ? 1 : 0) != 0, (Object)"Cannot get column definition");
        Descriptor returnedType = new Descriptor((List)columnHandles.stream().map(LokiColumnHandle.class::cast).map(column -> new Descriptor.Field(column.name(), Optional.of(column.type()))).collect(ImmutableList.toImmutableList()));
        Instant end = QueryRangeTableFunction.toInstant(endArgument);
        Instant start = QueryRangeTableFunction.toInstant(startArgument);
        LokiTableHandle tableHandle = new LokiTableHandle(query, start, end, step.intValue(), columnHandles);
        return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)new QueryHandle(tableHandle)).build();
    }

    private static Instant toInstant(LongTimestampWithTimeZone timestamp) {
        long epochSeconds = Math.floorDiv(timestamp.getEpochMillis(), 1000);
        long nanosOfSecond = (long)Math.floorMod(timestamp.getEpochMillis(), 1000) * 1000000L + (long)(timestamp.getPicosOfMilli() / 1000);
        return Instant.ofEpochSecond(epochSeconds, nanosOfSecond);
    }

    public record QueryHandle(LokiTableHandle tableHandle) implements ConnectorTableFunctionHandle
    {
        public QueryHandle {
            Objects.requireNonNull(tableHandle, "tableHandle is null");
        }
    }
}

