/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import io.trino.GroupByHashPageIndexer;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class GroupByHashPageIndexerFactory
implements PageIndexerFactory {
    private final JoinCompiler joinCompiler;
    private final BlockTypeOperators blockTypeOperators;

    @Inject
    public GroupByHashPageIndexerFactory(JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    public PageIndexer createPageIndexer(List<? extends Type> types) {
        if (types.isEmpty()) {
            return new NoHashPageIndexer();
        }
        return new GroupByHashPageIndexer(types, this.joinCompiler, this.blockTypeOperators);
    }

    private static class NoHashPageIndexer
    implements PageIndexer {
        private NoHashPageIndexer() {
        }

        public int[] indexPage(Page page) {
            return new int[page.getPositionCount()];
        }

        public int getMaxIndex() {
            return 0;
        }
    }
}

