/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.informationschema;

import io.airlift.log.Logger;
import io.trino.FullConnectorSession;
import io.trino.connector.informationschema.InformationSchemaPageSource;
import io.trino.connector.informationschema.InformationSchemaTableHandle;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;

public class InformationSchemaPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Logger log = Logger.get(InformationSchemaPageSourceProvider.class);
    private final Metadata metadata;
    private final AccessControl accessControl;

    public InformationSchemaPageSourceProvider(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        log.debug("Building information schema table (queryId=%s; tableHandle=%s)", new Object[]{session.getQueryId(), informationSchemaTableHandle});
        return new InformationSchemaPageSource(((FullConnectorSession)session).getSession(), this.metadata, this.accessControl, (InformationSchemaTableHandle)tableHandle, columns);
    }
}

