/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class TableCommentSystemTable
implements SystemTable {
    private static final Logger LOG = Logger.get(TableCommentSystemTable.class);
    private static final SchemaTableName COMMENT_TABLE_NAME = new SchemaTableName("metadata", "table_comments");
    private static final ConnectorTableMetadata COMMENT_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(COMMENT_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("comment", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TableCommentSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return COMMENT_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Optional<String> catalogFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 1);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 2);
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)COMMENT_TABLE);
        for (String catalog : MetadataListing.listCatalogs(session, this.metadata, this.accessControl, catalogFilter).keySet()) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            Object names = ImmutableSet.of();
            try {
                names = MetadataListing.listTables(session, this.metadata, this.accessControl, prefix);
            }
            catch (TrinoException e) {
                LOG.debug((Throwable)e, "Failed to get tables for catalog: %s", new Object[]{catalog});
            }
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                SchemaTableName name = (SchemaTableName)iterator.next();
                QualifiedObjectName tableName = new QualifiedObjectName(prefix.getCatalogName(), name.getSchemaName(), name.getTableName());
                Optional comment = Optional.empty();
                try {
                    comment = this.metadata.getTableHandle(session, tableName).map(handle -> this.metadata.getTableMetadata(session, (TableHandle)handle)).map(metadata -> metadata.getMetadata().getComment()).get();
                }
                catch (TrinoException e) {
                    LOG.debug((Throwable)e, "Failed to get metadata for table: %s", new Object[]{name});
                }
                table.addRow(new Object[]{prefix.getCatalogName(), name.getSchemaName(), name.getTableName(), comment.orElse(null)});
            }
        }
        return table.build().cursor();
    }
}

