/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.StatsProvider;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AggregationStatsRule
extends SimpleStatsRule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    public AggregationStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(AggregationNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        if (node.getGroupingSetCount() != 1) {
            return Optional.empty();
        }
        if (node.getStep() != AggregationNode.Step.SINGLE) {
            return Optional.empty();
        }
        return Optional.of(AggregationStatsRule.groupBy(statsProvider.getStats(node.getSource()), node.getGroupingKeys(), node.getAggregations()));
    }

    public static PlanNodeStatsEstimate groupBy(PlanNodeStatsEstimate sourceStats, Collection<Symbol> groupBySymbols, Map<Symbol, AggregationNode.Aggregation> aggregations) {
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        for (Symbol groupBySymbol : groupBySymbols) {
            SymbolStatsEstimate symbolStatistics = sourceStats.getSymbolStatistics(groupBySymbol);
            result.addSymbolStatistics(groupBySymbol, symbolStatistics.mapNullsFraction(nullsFraction -> {
                if (nullsFraction == 0.0) {
                    return 0.0;
                }
                return 1.0 / (symbolStatistics.getDistinctValuesCount() + 1.0);
            }));
        }
        double rowsCount = 1.0;
        for (Symbol symbol : groupBySymbols) {
            SymbolStatsEstimate symbolStatistics = sourceStats.getSymbolStatistics(symbol);
            boolean nullRow = symbolStatistics.getNullsFraction() != 0.0;
            rowsCount *= symbolStatistics.getDistinctValuesCount() + (double)nullRow;
        }
        result.setOutputRowCount(Math.min(rowsCount, sourceStats.getOutputRowCount()));
        for (Map.Entry entry : aggregations.entrySet()) {
            result.addSymbolStatistics((Symbol)entry.getKey(), AggregationStatsRule.estimateAggregationStats((AggregationNode.Aggregation)entry.getValue(), sourceStats));
        }
        return result.build();
    }

    private static SymbolStatsEstimate estimateAggregationStats(AggregationNode.Aggregation aggregation, PlanNodeStatsEstimate sourceStats) {
        Objects.requireNonNull(aggregation, "aggregation is null");
        Objects.requireNonNull(sourceStats, "sourceStats is null");
        return SymbolStatsEstimate.unknown();
    }
}

