/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import io.airlift.units.Duration;
import io.trino.dispatcher.CoordinatorLocation;
import io.trino.execution.ExecutionFailureInfo;
import java.util.Objects;
import java.util.Optional;

public class DispatchInfo {
    private final Optional<CoordinatorLocation> coordinatorLocation;
    private final Optional<ExecutionFailureInfo> failureInfo;
    private final Duration elapsedTime;
    private final Duration queuedTime;

    public static DispatchInfo queued(Duration elapsedTime, Duration queuedTime) {
        return new DispatchInfo(Optional.empty(), Optional.empty(), elapsedTime, queuedTime);
    }

    public static DispatchInfo dispatched(CoordinatorLocation coordinatorLocation, Duration elapsedTime, Duration queuedTime) {
        Objects.requireNonNull(coordinatorLocation, "coordinatorLocation is null");
        return new DispatchInfo(Optional.of(coordinatorLocation), Optional.empty(), elapsedTime, queuedTime);
    }

    public static DispatchInfo failed(ExecutionFailureInfo failureInfo, Duration elapsedTime, Duration queuedTime) {
        Objects.requireNonNull(failureInfo, "coordinatorLocation is null");
        return new DispatchInfo(Optional.empty(), Optional.of(failureInfo), elapsedTime, queuedTime);
    }

    private DispatchInfo(Optional<CoordinatorLocation> coordinatorLocation, Optional<ExecutionFailureInfo> failureInfo, Duration elapsedTime, Duration queuedTime) {
        this.coordinatorLocation = Objects.requireNonNull(coordinatorLocation, "coordinatorLocation is null");
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
    }

    public Optional<CoordinatorLocation> getCoordinatorLocation() {
        return this.coordinatorLocation;
    }

    public Optional<ExecutionFailureInfo> getFailureInfo() {
        return this.failureInfo;
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    public Duration getQueuedTime() {
        return this.queuedTime;
    }
}

