/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Statement;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CreateSchemaTask
implements DataDefinitionTask<CreateSchema> {
    @Override
    public String getName() {
        return "CREATE SCHEMA";
    }

    @Override
    public String explain(CreateSchema statement, List<Expression> parameters) {
        return "CREATE SCHEMA " + statement.getSchemaName();
    }

    @Override
    public ListenableFuture<?> execute(CreateSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        return this.internalExecute(statement, metadata, accessControl, stateMachine.getSession(), parameters);
    }

    @VisibleForTesting
    ListenableFuture<?> internalExecute(CreateSchema statement, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters) {
        block4: {
            CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName()));
            accessControl.checkCanCreateSchema(session.toSecurityContext(), schema);
            if (metadata.schemaExists(session, schema)) {
                if (!statement.isNotExists()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Schema '%s' already exists", schema);
                }
                return Futures.immediateFuture(null);
            }
            CatalogName catalogName = metadata.getCatalogHandle(session, schema.getCatalogName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + schema.getCatalogName()));
            Map<String, Object> properties = metadata.getSchemaPropertyManager().getProperties(catalogName, schema.getCatalogName(), NodeUtils.mapFromProperties(statement.getProperties()), session, metadata, accessControl, ParameterUtils.parameterExtractor((Statement)statement, parameters));
            TrinoPrincipal principal = this.getCreatePrincipal(statement, session, metadata);
            try {
                metadata.createSchema(session, schema, properties, principal);
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block4;
                throw e;
            }
        }
        return Futures.immediateFuture(null);
    }

    private TrinoPrincipal getCreatePrincipal(CreateSchema statement, Session session, Metadata metadata) {
        if (statement.getPrincipal().isPresent()) {
            TrinoPrincipal principal = MetadataUtil.createPrincipal((PrincipalSpecification)statement.getPrincipal().get());
            String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
            if (principal.getType() == PrincipalType.ROLE && !metadata.listRoles(session, catalog).contains(principal.getName())) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", principal.getName());
            }
            return principal;
        }
        return new TrinoPrincipal(PrincipalType.USER, session.getUser());
    }
}

